package zio.aws.health.model
import zio.aws.health.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAffectedEntitiesResponse(
    entities: Optional[Iterable[zio.aws.health.model.AffectedEntity]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesResponse = {
    import DescribeAffectedEntitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesResponse
      .builder()
      .optionallyWith(
        entities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entities)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.health.model.DescribeAffectedEntitiesResponse.ReadOnly =
    zio.aws.health.model.DescribeAffectedEntitiesResponse.wrap(buildAwsValue())
}
object DescribeAffectedEntitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.DescribeAffectedEntitiesResponse =
      zio.aws.health.model.DescribeAffectedEntitiesResponse(
        entities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def entities: Optional[List[zio.aws.health.model.AffectedEntity.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getEntities: ZIO[Any, AwsError, List[
      zio.aws.health.model.AffectedEntity.ReadOnly
    ]] = AwsError.unwrapOptionField("entities", entities)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesResponse
  ) extends zio.aws.health.model.DescribeAffectedEntitiesResponse.ReadOnly {
    override val entities
        : Optional[List[zio.aws.health.model.AffectedEntity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.AffectedEntity.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.health.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesResponse
  ): zio.aws.health.model.DescribeAffectedEntitiesResponse.ReadOnly =
    new Wrapper(impl)
}
