package zio.aws.health.model
import zio.aws.health.model.primitives.EventArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEntityAggregatesRequest(
    eventArns: Optional[Iterable[EventArn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeEntityAggregatesRequest = {
    import DescribeEntityAggregatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeEntityAggregatesRequest
      .builder()
      .optionallyWith(
        eventArns.map(value =>
          value.map { item =>
            EventArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.eventArns)
      .build()
  }
  def asReadOnly
      : zio.aws.health.model.DescribeEntityAggregatesRequest.ReadOnly =
    zio.aws.health.model.DescribeEntityAggregatesRequest.wrap(buildAwsValue())
}
object DescribeEntityAggregatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeEntityAggregatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.DescribeEntityAggregatesRequest =
      zio.aws.health.model
        .DescribeEntityAggregatesRequest(eventArns.map(value => value))
    def eventArns: Optional[List[EventArn]]
    def getEventArns: ZIO[Any, AwsError, List[EventArn]] =
      AwsError.unwrapOptionField("eventArns", eventArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeEntityAggregatesRequest
  ) extends zio.aws.health.model.DescribeEntityAggregatesRequest.ReadOnly {
    override val eventArns: Optional[List[EventArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.eventArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.health.model.primitives.EventArn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeEntityAggregatesRequest
  ): zio.aws.health.model.DescribeEntityAggregatesRequest.ReadOnly =
    new Wrapper(impl)
}
