package zio.aws.health.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEntityAggregatesResponse(
    entityAggregates: Optional[Iterable[zio.aws.health.model.EntityAggregate]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeEntityAggregatesResponse = {
    import DescribeEntityAggregatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeEntityAggregatesResponse
      .builder()
      .optionallyWith(
        entityAggregates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entityAggregates)
      .build()
  }
  def asReadOnly
      : zio.aws.health.model.DescribeEntityAggregatesResponse.ReadOnly =
    zio.aws.health.model.DescribeEntityAggregatesResponse.wrap(buildAwsValue())
}
object DescribeEntityAggregatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeEntityAggregatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.DescribeEntityAggregatesResponse =
      zio.aws.health.model.DescribeEntityAggregatesResponse(
        entityAggregates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def entityAggregates
        : Optional[List[zio.aws.health.model.EntityAggregate.ReadOnly]]
    def getEntityAggregates: ZIO[Any, AwsError, List[
      zio.aws.health.model.EntityAggregate.ReadOnly
    ]] = AwsError.unwrapOptionField("entityAggregates", entityAggregates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeEntityAggregatesResponse
  ) extends zio.aws.health.model.DescribeEntityAggregatesResponse.ReadOnly {
    override val entityAggregates
        : Optional[List[zio.aws.health.model.EntityAggregate.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entityAggregates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.EntityAggregate.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeEntityAggregatesResponse
  ): zio.aws.health.model.DescribeEntityAggregatesResponse.ReadOnly =
    new Wrapper(impl)
}
