package zio.aws.health.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.health.model.primitives.{NextToken, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeEventAggregatesRequest(
    filter: Optional[zio.aws.health.model.EventFilter] = Optional.Absent,
    aggregateField: zio.aws.health.model.EventAggregateField,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest = {
    import DescribeEventAggregatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .aggregateField(aggregateField.unwrap)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.health.model.DescribeEventAggregatesRequest.ReadOnly =
    zio.aws.health.model.DescribeEventAggregatesRequest.wrap(buildAwsValue())
}
object DescribeEventAggregatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.DescribeEventAggregatesRequest =
      zio.aws.health.model.DescribeEventAggregatesRequest(
        filter.map(value => value.asEditable),
        aggregateField,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filter: Optional[zio.aws.health.model.EventFilter.ReadOnly]
    def aggregateField: zio.aws.health.model.EventAggregateField
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getFilter
        : ZIO[Any, AwsError, zio.aws.health.model.EventFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getAggregateField
        : ZIO[Any, Nothing, zio.aws.health.model.EventAggregateField] =
      ZIO.succeed(aggregateField)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest
  ) extends zio.aws.health.model.DescribeEventAggregatesRequest.ReadOnly {
    override val filter: Optional[zio.aws.health.model.EventFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.health.model.EventFilter.wrap(value))
    override val aggregateField: zio.aws.health.model.EventAggregateField =
      zio.aws.health.model.EventAggregateField.wrap(impl.aggregateField())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.health.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.health.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest
  ): zio.aws.health.model.DescribeEventAggregatesRequest.ReadOnly = new Wrapper(
    impl
  )
}
