package zio.aws.health.model
import zio.aws.health.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEventAggregatesResponse(
    eventAggregates: Optional[Iterable[zio.aws.health.model.EventAggregate]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeEventAggregatesResponse = {
    import DescribeEventAggregatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeEventAggregatesResponse
      .builder()
      .optionallyWith(
        eventAggregates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventAggregates)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.health.model.DescribeEventAggregatesResponse.ReadOnly =
    zio.aws.health.model.DescribeEventAggregatesResponse.wrap(buildAwsValue())
}
object DescribeEventAggregatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeEventAggregatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.DescribeEventAggregatesResponse =
      zio.aws.health.model.DescribeEventAggregatesResponse(
        eventAggregates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def eventAggregates
        : Optional[List[zio.aws.health.model.EventAggregate.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getEventAggregates: ZIO[Any, AwsError, List[
      zio.aws.health.model.EventAggregate.ReadOnly
    ]] = AwsError.unwrapOptionField("eventAggregates", eventAggregates)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeEventAggregatesResponse
  ) extends zio.aws.health.model.DescribeEventAggregatesResponse.ReadOnly {
    override val eventAggregates
        : Optional[List[zio.aws.health.model.EventAggregate.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventAggregates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.EventAggregate.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.health.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeEventAggregatesResponse
  ): zio.aws.health.model.DescribeEventAggregatesResponse.ReadOnly =
    new Wrapper(impl)
}
