package zio.aws.health.model
import zio.aws.health.model.primitives.Locale
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEventDetailsForOrganizationRequest(
    organizationEventDetailFilters: Iterable[
      zio.aws.health.model.EventAccountFilter
    ],
    locale: Optional[Locale] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeEventDetailsForOrganizationRequest = {
    import DescribeEventDetailsForOrganizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeEventDetailsForOrganizationRequest
      .builder()
      .organizationEventDetailFilters(organizationEventDetailFilters.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        locale.map(value => Locale.unwrap(value): java.lang.String)
      )(_.locale)
      .build()
  }
  def asReadOnly
      : zio.aws.health.model.DescribeEventDetailsForOrganizationRequest.ReadOnly =
    zio.aws.health.model.DescribeEventDetailsForOrganizationRequest
      .wrap(buildAwsValue())
}
object DescribeEventDetailsForOrganizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeEventDetailsForOrganizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.health.model.DescribeEventDetailsForOrganizationRequest =
      zio.aws.health.model.DescribeEventDetailsForOrganizationRequest(
        organizationEventDetailFilters.map { item =>
          item.asEditable
        },
        locale.map(value => value)
      )
    def organizationEventDetailFilters
        : List[zio.aws.health.model.EventAccountFilter.ReadOnly]
    def locale: Optional[Locale]
    def getOrganizationEventDetailFilters: ZIO[Any, Nothing, List[
      zio.aws.health.model.EventAccountFilter.ReadOnly
    ]] = ZIO.succeed(organizationEventDetailFilters)
    def getLocale: ZIO[Any, AwsError, Locale] =
      AwsError.unwrapOptionField("locale", locale)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeEventDetailsForOrganizationRequest
  ) extends zio.aws.health.model.DescribeEventDetailsForOrganizationRequest.ReadOnly {
    override val organizationEventDetailFilters
        : List[zio.aws.health.model.EventAccountFilter.ReadOnly] = impl
      .organizationEventDetailFilters()
      .asScala
      .map { item =>
        zio.aws.health.model.EventAccountFilter.wrap(item)
      }
      .toList
    override val locale: Optional[Locale] = zio.aws.core.internal
      .optionalFromNullable(impl.locale())
      .map(value => zio.aws.health.model.primitives.Locale(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeEventDetailsForOrganizationRequest
  ): zio.aws.health.model.DescribeEventDetailsForOrganizationRequest.ReadOnly =
    new Wrapper(impl)
}
