package zio.aws.health.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEventDetailsForOrganizationResponse(
    successfulSet: Optional[
      Iterable[zio.aws.health.model.OrganizationEventDetails]
    ] = Optional.Absent,
    failedSet: Optional[
      Iterable[zio.aws.health.model.OrganizationEventDetailsErrorItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeEventDetailsForOrganizationResponse = {
    import DescribeEventDetailsForOrganizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeEventDetailsForOrganizationResponse
      .builder()
      .optionallyWith(
        successfulSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successfulSet)
      .optionallyWith(
        failedSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedSet)
      .build()
  }
  def asReadOnly
      : zio.aws.health.model.DescribeEventDetailsForOrganizationResponse.ReadOnly =
    zio.aws.health.model.DescribeEventDetailsForOrganizationResponse
      .wrap(buildAwsValue())
}
object DescribeEventDetailsForOrganizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeEventDetailsForOrganizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.health.model.DescribeEventDetailsForOrganizationResponse =
      zio.aws.health.model.DescribeEventDetailsForOrganizationResponse(
        successfulSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failedSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successfulSet
        : Optional[List[zio.aws.health.model.OrganizationEventDetails.ReadOnly]]
    def failedSet: Optional[
      List[zio.aws.health.model.OrganizationEventDetailsErrorItem.ReadOnly]
    ]
    def getSuccessfulSet: ZIO[Any, AwsError, List[
      zio.aws.health.model.OrganizationEventDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("successfulSet", successfulSet)
    def getFailedSet: ZIO[Any, AwsError, List[
      zio.aws.health.model.OrganizationEventDetailsErrorItem.ReadOnly
    ]] = AwsError.unwrapOptionField("failedSet", failedSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeEventDetailsForOrganizationResponse
  ) extends zio.aws.health.model.DescribeEventDetailsForOrganizationResponse.ReadOnly {
    override val successfulSet: Optional[
      List[zio.aws.health.model.OrganizationEventDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.successfulSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.health.model.OrganizationEventDetails.wrap(item)
        }.toList
      )
    override val failedSet: Optional[
      List[zio.aws.health.model.OrganizationEventDetailsErrorItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failedSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.health.model.OrganizationEventDetailsErrorItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeEventDetailsForOrganizationResponse
  ): zio.aws.health.model.DescribeEventDetailsForOrganizationResponse.ReadOnly =
    new Wrapper(impl)
}
