package zio.aws.health.model
import zio.aws.health.model.primitives.{Locale, EventArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEventDetailsRequest(
    eventArns: Iterable[EventArn],
    locale: Optional[Locale] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeEventDetailsRequest = {
    import DescribeEventDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeEventDetailsRequest
      .builder()
      .eventArns(eventArns.map { item =>
        EventArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        locale.map(value => Locale.unwrap(value): java.lang.String)
      )(_.locale)
      .build()
  }
  def asReadOnly: zio.aws.health.model.DescribeEventDetailsRequest.ReadOnly =
    zio.aws.health.model.DescribeEventDetailsRequest.wrap(buildAwsValue())
}
object DescribeEventDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeEventDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.DescribeEventDetailsRequest =
      zio.aws.health.model
        .DescribeEventDetailsRequest(eventArns, locale.map(value => value))
    def eventArns: List[EventArn]
    def locale: Optional[Locale]
    def getEventArns: ZIO[Any, Nothing, List[EventArn]] = ZIO.succeed(eventArns)
    def getLocale: ZIO[Any, AwsError, Locale] =
      AwsError.unwrapOptionField("locale", locale)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeEventDetailsRequest
  ) extends zio.aws.health.model.DescribeEventDetailsRequest.ReadOnly {
    override val eventArns: List[EventArn] = impl
      .eventArns()
      .asScala
      .map { item =>
        zio.aws.health.model.primitives.EventArn(item)
      }
      .toList
    override val locale: Optional[Locale] = zio.aws.core.internal
      .optionalFromNullable(impl.locale())
      .map(value => zio.aws.health.model.primitives.Locale(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeEventDetailsRequest
  ): zio.aws.health.model.DescribeEventDetailsRequest.ReadOnly = new Wrapper(
    impl
  )
}
