package zio.aws.health.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEventDetailsResponse(
    successfulSet: Optional[Iterable[zio.aws.health.model.EventDetails]] =
      Optional.Absent,
    failedSet: Optional[Iterable[zio.aws.health.model.EventDetailsErrorItem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeEventDetailsResponse = {
    import DescribeEventDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeEventDetailsResponse
      .builder()
      .optionallyWith(
        successfulSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successfulSet)
      .optionallyWith(
        failedSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedSet)
      .build()
  }
  def asReadOnly: zio.aws.health.model.DescribeEventDetailsResponse.ReadOnly =
    zio.aws.health.model.DescribeEventDetailsResponse.wrap(buildAwsValue())
}
object DescribeEventDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeEventDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.DescribeEventDetailsResponse =
      zio.aws.health.model.DescribeEventDetailsResponse(
        successfulSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failedSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successfulSet
        : Optional[List[zio.aws.health.model.EventDetails.ReadOnly]]
    def failedSet
        : Optional[List[zio.aws.health.model.EventDetailsErrorItem.ReadOnly]]
    def getSuccessfulSet
        : ZIO[Any, AwsError, List[zio.aws.health.model.EventDetails.ReadOnly]] =
      AwsError.unwrapOptionField("successfulSet", successfulSet)
    def getFailedSet: ZIO[Any, AwsError, List[
      zio.aws.health.model.EventDetailsErrorItem.ReadOnly
    ]] = AwsError.unwrapOptionField("failedSet", failedSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeEventDetailsResponse
  ) extends zio.aws.health.model.DescribeEventDetailsResponse.ReadOnly {
    override val successfulSet
        : Optional[List[zio.aws.health.model.EventDetails.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successfulSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.EventDetails.wrap(item)
          }.toList
        )
    override val failedSet
        : Optional[List[zio.aws.health.model.EventDetailsErrorItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.EventDetailsErrorItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeEventDetailsResponse
  ): zio.aws.health.model.DescribeEventDetailsResponse.ReadOnly = new Wrapper(
    impl
  )
}
