package zio.aws.health.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.health.model.primitives.{MaxResults, NextToken, Locale}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeEventTypesRequest(
    filter: Optional[zio.aws.health.model.EventTypeFilter] = Optional.Absent,
    locale: Optional[Locale] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeEventTypesRequest = {
    import DescribeEventTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeEventTypesRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        locale.map(value => Locale.unwrap(value): java.lang.String)
      )(_.locale)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.health.model.DescribeEventTypesRequest.ReadOnly =
    zio.aws.health.model.DescribeEventTypesRequest.wrap(buildAwsValue())
}
object DescribeEventTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeEventTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.DescribeEventTypesRequest =
      zio.aws.health.model.DescribeEventTypesRequest(
        filter.map(value => value.asEditable),
        locale.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filter: Optional[zio.aws.health.model.EventTypeFilter.ReadOnly]
    def locale: Optional[Locale]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getFilter
        : ZIO[Any, AwsError, zio.aws.health.model.EventTypeFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getLocale: ZIO[Any, AwsError, Locale] =
      AwsError.unwrapOptionField("locale", locale)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeEventTypesRequest
  ) extends zio.aws.health.model.DescribeEventTypesRequest.ReadOnly {
    override val filter
        : Optional[zio.aws.health.model.EventTypeFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.health.model.EventTypeFilter.wrap(value))
    override val locale: Optional[Locale] = zio.aws.core.internal
      .optionalFromNullable(impl.locale())
      .map(value => zio.aws.health.model.primitives.Locale(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.health.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.health.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeEventTypesRequest
  ): zio.aws.health.model.DescribeEventTypesRequest.ReadOnly = new Wrapper(impl)
}
