package zio.aws.health.model
import zio.aws.health.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEventTypesResponse(
    eventTypes: Optional[Iterable[zio.aws.health.model.EventType]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeEventTypesResponse = {
    import DescribeEventTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeEventTypesResponse
      .builder()
      .optionallyWith(
        eventTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventTypes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.health.model.DescribeEventTypesResponse.ReadOnly =
    zio.aws.health.model.DescribeEventTypesResponse.wrap(buildAwsValue())
}
object DescribeEventTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeEventTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.DescribeEventTypesResponse =
      zio.aws.health.model.DescribeEventTypesResponse(
        eventTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def eventTypes: Optional[List[zio.aws.health.model.EventType.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getEventTypes
        : ZIO[Any, AwsError, List[zio.aws.health.model.EventType.ReadOnly]] =
      AwsError.unwrapOptionField("eventTypes", eventTypes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeEventTypesResponse
  ) extends zio.aws.health.model.DescribeEventTypesResponse.ReadOnly {
    override val eventTypes
        : Optional[List[zio.aws.health.model.EventType.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.EventType.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.health.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeEventTypesResponse
  ): zio.aws.health.model.DescribeEventTypesResponse.ReadOnly = new Wrapper(
    impl
  )
}
