package zio.aws.health.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.health.model.primitives.{Locale, MaxResultsLowerRange, NextToken}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeEventsForOrganizationRequest(
    filter: Optional[zio.aws.health.model.OrganizationEventFilter] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResultsLowerRange] = Optional.Absent,
    locale: Optional[Locale] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationRequest = {
    import DescribeEventsForOrganizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResultsLowerRange.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        locale.map(value => Locale.unwrap(value): java.lang.String)
      )(_.locale)
      .build()
  }
  def asReadOnly
      : zio.aws.health.model.DescribeEventsForOrganizationRequest.ReadOnly =
    zio.aws.health.model.DescribeEventsForOrganizationRequest
      .wrap(buildAwsValue())
}
object DescribeEventsForOrganizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.DescribeEventsForOrganizationRequest =
      zio.aws.health.model.DescribeEventsForOrganizationRequest(
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value),
        locale.map(value => value)
      )
    def filter: Optional[zio.aws.health.model.OrganizationEventFilter.ReadOnly]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResultsLowerRange]
    def locale: Optional[Locale]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.health.model.OrganizationEventFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsLowerRange] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getLocale: ZIO[Any, AwsError, Locale] =
      AwsError.unwrapOptionField("locale", locale)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationRequest
  ) extends zio.aws.health.model.DescribeEventsForOrganizationRequest.ReadOnly {
    override val filter
        : Optional[zio.aws.health.model.OrganizationEventFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.health.model.OrganizationEventFilter.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.health.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResultsLowerRange] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.health.model.primitives.MaxResultsLowerRange(value)
        )
    override val locale: Optional[Locale] = zio.aws.core.internal
      .optionalFromNullable(impl.locale())
      .map(value => zio.aws.health.model.primitives.Locale(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationRequest
  ): zio.aws.health.model.DescribeEventsForOrganizationRequest.ReadOnly =
    new Wrapper(impl)
}
