package zio.aws.health.model
import zio.aws.health.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEventsForOrganizationResponse(
    events: Optional[Iterable[zio.aws.health.model.OrganizationEvent]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationResponse = {
    import DescribeEventsForOrganizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationResponse
      .builder()
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.health.model.DescribeEventsForOrganizationResponse.ReadOnly =
    zio.aws.health.model.DescribeEventsForOrganizationResponse
      .wrap(buildAwsValue())
}
object DescribeEventsForOrganizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.DescribeEventsForOrganizationResponse =
      zio.aws.health.model.DescribeEventsForOrganizationResponse(
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def events: Optional[List[zio.aws.health.model.OrganizationEvent.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getEvents: ZIO[Any, AwsError, List[
      zio.aws.health.model.OrganizationEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationResponse
  ) extends zio.aws.health.model.DescribeEventsForOrganizationResponse.ReadOnly {
    override val events
        : Optional[List[zio.aws.health.model.OrganizationEvent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.OrganizationEvent.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.health.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationResponse
  ): zio.aws.health.model.DescribeEventsForOrganizationResponse.ReadOnly =
    new Wrapper(impl)
}
