package zio.aws.health.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.health.model.primitives.{Locale, MaxResults, NextToken}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeEventsRequest(
    filter: Optional[zio.aws.health.model.EventFilter] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    locale: Optional[Locale] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeEventsRequest = {
    import DescribeEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeEventsRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        locale.map(value => Locale.unwrap(value): java.lang.String)
      )(_.locale)
      .build()
  }
  def asReadOnly: zio.aws.health.model.DescribeEventsRequest.ReadOnly =
    zio.aws.health.model.DescribeEventsRequest.wrap(buildAwsValue())
}
object DescribeEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.DescribeEventsRequest =
      zio.aws.health.model.DescribeEventsRequest(
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value),
        locale.map(value => value)
      )
    def filter: Optional[zio.aws.health.model.EventFilter.ReadOnly]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def locale: Optional[Locale]
    def getFilter
        : ZIO[Any, AwsError, zio.aws.health.model.EventFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getLocale: ZIO[Any, AwsError, Locale] =
      AwsError.unwrapOptionField("locale", locale)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeEventsRequest
  ) extends zio.aws.health.model.DescribeEventsRequest.ReadOnly {
    override val filter: Optional[zio.aws.health.model.EventFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.health.model.EventFilter.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.health.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.health.model.primitives.MaxResults(value))
    override val locale: Optional[Locale] = zio.aws.core.internal
      .optionalFromNullable(impl.locale())
      .map(value => zio.aws.health.model.primitives.Locale(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeEventsRequest
  ): zio.aws.health.model.DescribeEventsRequest.ReadOnly = new Wrapper(impl)
}
