package zio.aws.health.model
import zio.aws.health.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEventsResponse(
    events: Optional[Iterable[zio.aws.health.model.Event]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeEventsResponse = {
    import DescribeEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeEventsResponse
      .builder()
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.health.model.DescribeEventsResponse.ReadOnly =
    zio.aws.health.model.DescribeEventsResponse.wrap(buildAwsValue())
}
object DescribeEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.DescribeEventsResponse =
      zio.aws.health.model.DescribeEventsResponse(
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def events: Optional[List[zio.aws.health.model.Event.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getEvents
        : ZIO[Any, AwsError, List[zio.aws.health.model.Event.ReadOnly]] =
      AwsError.unwrapOptionField("events", events)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeEventsResponse
  ) extends zio.aws.health.model.DescribeEventsResponse.ReadOnly {
    override val events: Optional[List[zio.aws.health.model.Event.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.Event.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.health.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeEventsResponse
  ): zio.aws.health.model.DescribeEventsResponse.ReadOnly = new Wrapper(impl)
}
