package zio.aws.health.model
import zio.aws.health.model.primitives.HealthServiceAccessStatusForOrganization
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeHealthServiceStatusForOrganizationResponse(
    healthServiceAccessStatusForOrganization: Optional[
      HealthServiceAccessStatusForOrganization
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeHealthServiceStatusForOrganizationResponse = {
    import DescribeHealthServiceStatusForOrganizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeHealthServiceStatusForOrganizationResponse
      .builder()
      .optionallyWith(
        healthServiceAccessStatusForOrganization.map(value =>
          HealthServiceAccessStatusForOrganization.unwrap(
            value
          ): java.lang.String
        )
      )(_.healthServiceAccessStatusForOrganization)
      .build()
  }
  def asReadOnly
      : zio.aws.health.model.DescribeHealthServiceStatusForOrganizationResponse.ReadOnly =
    zio.aws.health.model.DescribeHealthServiceStatusForOrganizationResponse
      .wrap(buildAwsValue())
}
object DescribeHealthServiceStatusForOrganizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeHealthServiceStatusForOrganizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.health.model.DescribeHealthServiceStatusForOrganizationResponse =
      zio.aws.health.model.DescribeHealthServiceStatusForOrganizationResponse(
        healthServiceAccessStatusForOrganization.map(value => value)
      )
    def healthServiceAccessStatusForOrganization
        : Optional[HealthServiceAccessStatusForOrganization]
    def getHealthServiceAccessStatusForOrganization
        : ZIO[Any, AwsError, HealthServiceAccessStatusForOrganization] =
      AwsError.unwrapOptionField(
        "healthServiceAccessStatusForOrganization",
        healthServiceAccessStatusForOrganization
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeHealthServiceStatusForOrganizationResponse
  ) extends zio.aws.health.model.DescribeHealthServiceStatusForOrganizationResponse.ReadOnly {
    override val healthServiceAccessStatusForOrganization
        : Optional[HealthServiceAccessStatusForOrganization] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthServiceAccessStatusForOrganization())
        .map(value =>
          zio.aws.health.model.primitives
            .HealthServiceAccessStatusForOrganization(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeHealthServiceStatusForOrganizationResponse
  ): zio.aws.health.model.DescribeHealthServiceStatusForOrganizationResponse.ReadOnly =
    new Wrapper(impl)
}
