package zio.aws.health.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.health.model.primitives.{Count, EventArn}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EntityAggregate(
    eventArn: Optional[EventArn] = Optional.Absent,
    count: Optional[Count] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.EntityAggregate = {
    import EntityAggregate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.EntityAggregate
      .builder()
      .optionallyWith(
        eventArn.map(value => EventArn.unwrap(value): java.lang.String)
      )(_.eventArn)
      .optionallyWith(count.map(value => Count.unwrap(value): Integer))(_.count)
      .build()
  }
  def asReadOnly: zio.aws.health.model.EntityAggregate.ReadOnly =
    zio.aws.health.model.EntityAggregate.wrap(buildAwsValue())
}
object EntityAggregate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.EntityAggregate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.EntityAggregate = zio.aws.health.model
      .EntityAggregate(eventArn.map(value => value), count.map(value => value))
    def eventArn: Optional[EventArn]
    def count: Optional[Count]
    def getEventArn: ZIO[Any, AwsError, EventArn] =
      AwsError.unwrapOptionField("eventArn", eventArn)
    def getCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.EntityAggregate
  ) extends zio.aws.health.model.EntityAggregate.ReadOnly {
    override val eventArn: Optional[EventArn] = zio.aws.core.internal
      .optionalFromNullable(impl.eventArn())
      .map(value => zio.aws.health.model.primitives.EventArn(value))
    override val count: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => zio.aws.health.model.primitives.Count(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.EntityAggregate
  ): zio.aws.health.model.EntityAggregate.ReadOnly = new Wrapper(impl)
}
