package zio.aws.health.model
import zio.aws.health.model.primitives.{
  EntityValue,
  EntityArn,
  TagValue,
  EventArn,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EntityFilter(
    eventArns: Iterable[EventArn],
    entityArns: Optional[Iterable[EntityArn]] = Optional.Absent,
    entityValues: Optional[Iterable[EntityValue]] = Optional.Absent,
    lastUpdatedTimes: Optional[Iterable[zio.aws.health.model.DateTimeRange]] =
      Optional.Absent,
    tags: Optional[Iterable[Map[TagKey, TagValue]]] = Optional.Absent,
    statusCodes: Optional[Iterable[zio.aws.health.model.EntityStatusCode]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.EntityFilter = {
    import EntityFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.EntityFilter
      .builder()
      .eventArns(eventArns.map { item =>
        EventArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        entityArns.map(value =>
          value.map { item =>
            EntityArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.entityArns)
      .optionallyWith(
        entityValues.map(value =>
          value.map { item =>
            EntityValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.entityValues)
      .optionallyWith(
        lastUpdatedTimes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lastUpdatedTimes)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                  value
                ): java.lang.String)
              })
              .asJava
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        statusCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statusCodesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.health.model.EntityFilter.ReadOnly =
    zio.aws.health.model.EntityFilter.wrap(buildAwsValue())
}
object EntityFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.EntityFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.EntityFilter =
      zio.aws.health.model.EntityFilter(
        eventArns,
        entityArns.map(value => value),
        entityValues.map(value => value),
        lastUpdatedTimes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        statusCodes.map(value => value)
      )
    def eventArns: List[EventArn]
    def entityArns: Optional[List[EntityArn]]
    def entityValues: Optional[List[EntityValue]]
    def lastUpdatedTimes
        : Optional[List[zio.aws.health.model.DateTimeRange.ReadOnly]]
    def tags: Optional[List[Map[TagKey, TagValue]]]
    def statusCodes: Optional[List[zio.aws.health.model.EntityStatusCode]]
    def getEventArns: ZIO[Any, Nothing, List[EventArn]] = ZIO.succeed(eventArns)
    def getEntityArns: ZIO[Any, AwsError, List[EntityArn]] =
      AwsError.unwrapOptionField("entityArns", entityArns)
    def getEntityValues: ZIO[Any, AwsError, List[EntityValue]] =
      AwsError.unwrapOptionField("entityValues", entityValues)
    def getLastUpdatedTimes: ZIO[Any, AwsError, List[
      zio.aws.health.model.DateTimeRange.ReadOnly
    ]] = AwsError.unwrapOptionField("lastUpdatedTimes", lastUpdatedTimes)
    def getTags: ZIO[Any, AwsError, List[Map[TagKey, TagValue]]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStatusCodes
        : ZIO[Any, AwsError, List[zio.aws.health.model.EntityStatusCode]] =
      AwsError.unwrapOptionField("statusCodes", statusCodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.EntityFilter
  ) extends zio.aws.health.model.EntityFilter.ReadOnly {
    override val eventArns: List[EventArn] = impl
      .eventArns()
      .asScala
      .map { item =>
        zio.aws.health.model.primitives.EventArn(item)
      }
      .toList
    override val entityArns: Optional[List[EntityArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.entityArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.health.model.primitives.EntityArn(item)
        }.toList
      )
    override val entityValues: Optional[List[EntityValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entityValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.primitives.EntityValue(item)
          }.toList
        )
    override val lastUpdatedTimes
        : Optional[List[zio.aws.health.model.DateTimeRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.DateTimeRange.wrap(item)
          }.toList
        )
    override val tags: Optional[List[Map[TagKey, TagValue]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            item.asScala
              .map({ case (key, value) =>
                zio.aws.health.model.primitives.TagKey(
                  key
                ) -> zio.aws.health.model.primitives.TagValue(value)
              })
              .toMap
          }.toList
        )
    override val statusCodes
        : Optional[List[zio.aws.health.model.EntityStatusCode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.EntityStatusCode.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.EntityFilter
  ): zio.aws.health.model.EntityFilter.ReadOnly = new Wrapper(impl)
}
