package zio.aws.health.model
import scala.jdk.CollectionConverters._
sealed trait EntityStatusCode {
  def unwrap: software.amazon.awssdk.services.health.model.EntityStatusCode
}
object EntityStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.health.model.EntityStatusCode
  ): zio.aws.health.model.EntityStatusCode = value match {
    case software.amazon.awssdk.services.health.model.EntityStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.health.model.EntityStatusCode.IMPAIRED =>
      val r = IMPAIRED
      r
    case software.amazon.awssdk.services.health.model.EntityStatusCode.UNIMPAIRED =>
      val r = UNIMPAIRED
      r
    case software.amazon.awssdk.services.health.model.EntityStatusCode.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.health.model.EntityStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EntityStatusCode =
      software.amazon.awssdk.services.health.model.EntityStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object IMPAIRED extends zio.aws.health.model.EntityStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EntityStatusCode =
      software.amazon.awssdk.services.health.model.EntityStatusCode.IMPAIRED
  }
  case object UNIMPAIRED extends zio.aws.health.model.EntityStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EntityStatusCode =
      software.amazon.awssdk.services.health.model.EntityStatusCode.UNIMPAIRED
  }
  case object UNKNOWN extends zio.aws.health.model.EntityStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EntityStatusCode =
      software.amazon.awssdk.services.health.model.EntityStatusCode.UNKNOWN
  }
}
