package zio.aws.health.model
import zio.aws.health.model.primitives.{AccountId, EventArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EventAccountFilter(
    eventArn: EventArn,
    awsAccountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.EventAccountFilter = {
    import EventAccountFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.EventAccountFilter
      .builder()
      .eventArn(EventArn.unwrap(eventArn): java.lang.String)
      .optionallyWith(
        awsAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .build()
  }
  def asReadOnly: zio.aws.health.model.EventAccountFilter.ReadOnly =
    zio.aws.health.model.EventAccountFilter.wrap(buildAwsValue())
}
object EventAccountFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.EventAccountFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.EventAccountFilter =
      zio.aws.health.model
        .EventAccountFilter(eventArn, awsAccountId.map(value => value))
    def eventArn: EventArn
    def awsAccountId: Optional[AccountId]
    def getEventArn: ZIO[Any, Nothing, EventArn] = ZIO.succeed(eventArn)
    def getAwsAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.EventAccountFilter
  ) extends zio.aws.health.model.EventAccountFilter.ReadOnly {
    override val eventArn: EventArn =
      zio.aws.health.model.primitives.EventArn(impl.eventArn())
    override val awsAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.health.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.EventAccountFilter
  ): zio.aws.health.model.EventAccountFilter.ReadOnly = new Wrapper(impl)
}
