package zio.aws.health.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.health.model.primitives.{Count, AggregateValue}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EventAggregate(
    aggregateValue: Optional[AggregateValue] = Optional.Absent,
    count: Optional[Count] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.EventAggregate = {
    import EventAggregate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.EventAggregate
      .builder()
      .optionallyWith(
        aggregateValue.map(value =>
          AggregateValue.unwrap(value): java.lang.String
        )
      )(_.aggregateValue)
      .optionallyWith(count.map(value => Count.unwrap(value): Integer))(_.count)
      .build()
  }
  def asReadOnly: zio.aws.health.model.EventAggregate.ReadOnly =
    zio.aws.health.model.EventAggregate.wrap(buildAwsValue())
}
object EventAggregate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.EventAggregate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.EventAggregate =
      zio.aws.health.model.EventAggregate(
        aggregateValue.map(value => value),
        count.map(value => value)
      )
    def aggregateValue: Optional[AggregateValue]
    def count: Optional[Count]
    def getAggregateValue: ZIO[Any, AwsError, AggregateValue] =
      AwsError.unwrapOptionField("aggregateValue", aggregateValue)
    def getCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.EventAggregate
  ) extends zio.aws.health.model.EventAggregate.ReadOnly {
    override val aggregateValue: Optional[AggregateValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregateValue())
        .map(value => zio.aws.health.model.primitives.AggregateValue(value))
    override val count: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => zio.aws.health.model.primitives.Count(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.EventAggregate
  ): zio.aws.health.model.EventAggregate.ReadOnly = new Wrapper(impl)
}
