package zio.aws.health.model
import scala.jdk.CollectionConverters._
sealed trait EventAggregateField {
  def unwrap: software.amazon.awssdk.services.health.model.EventAggregateField
}
object EventAggregateField {
  def wrap(
      value: software.amazon.awssdk.services.health.model.EventAggregateField
  ): zio.aws.health.model.EventAggregateField = value match {
    case software.amazon.awssdk.services.health.model.EventAggregateField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.health.model.EventAggregateField.EVENT_TYPE_CATEGORY =>
      val r = eventTypeCategory
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.health.model.EventAggregateField {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EventAggregateField =
      software.amazon.awssdk.services.health.model.EventAggregateField.UNKNOWN_TO_SDK_VERSION
  }
  case object eventTypeCategory
      extends zio.aws.health.model.EventAggregateField {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EventAggregateField =
      software.amazon.awssdk.services.health.model.EventAggregateField.EVENT_TYPE_CATEGORY
  }
}
