package zio.aws.health.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EventDescription(
    latestDescription: Optional[
      zio.aws.health.model.primitives.EventDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.EventDescription = {
    import EventDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.EventDescription
      .builder()
      .optionallyWith(
        latestDescription.map(value =>
          zio.aws.health.model.primitives.EventDescription
            .unwrap(value): java.lang.String
        )
      )(_.latestDescription)
      .build()
  }
  def asReadOnly: zio.aws.health.model.EventDescription.ReadOnly =
    zio.aws.health.model.EventDescription.wrap(buildAwsValue())
}
object EventDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.EventDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.EventDescription = zio.aws.health.model
      .EventDescription(latestDescription.map(value => value))
    def latestDescription
        : Optional[zio.aws.health.model.primitives.EventDescription]
    def getLatestDescription
        : ZIO[Any, AwsError, zio.aws.health.model.primitives.EventDescription] =
      AwsError.unwrapOptionField("latestDescription", latestDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.EventDescription
  ) extends zio.aws.health.model.EventDescription.ReadOnly {
    override val latestDescription
        : Optional[zio.aws.health.model.primitives.EventDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestDescription())
        .map(value => zio.aws.health.model.primitives.EventDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.EventDescription
  ): zio.aws.health.model.EventDescription.ReadOnly = new Wrapper(impl)
}
