package zio.aws.health.model
import zio.aws.health.model.primitives.{MetadataValue, MetadataKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EventDetails(
    event: Optional[zio.aws.health.model.Event] = Optional.Absent,
    eventDescription: Optional[zio.aws.health.model.EventDescription] =
      Optional.Absent,
    eventMetadata: Optional[Map[MetadataKey, MetadataValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.EventDetails = {
    import EventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.EventDetails
      .builder()
      .optionallyWith(event.map(value => value.buildAwsValue()))(_.event)
      .optionallyWith(eventDescription.map(value => value.buildAwsValue()))(
        _.eventDescription
      )
      .optionallyWith(
        eventMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (MetadataKey.unwrap(key): java.lang.String) -> (MetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.eventMetadata)
      .build()
  }
  def asReadOnly: zio.aws.health.model.EventDetails.ReadOnly =
    zio.aws.health.model.EventDetails.wrap(buildAwsValue())
}
object EventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.EventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.EventDetails =
      zio.aws.health.model.EventDetails(
        event.map(value => value.asEditable),
        eventDescription.map(value => value.asEditable),
        eventMetadata.map(value => value)
      )
    def event: Optional[zio.aws.health.model.Event.ReadOnly]
    def eventDescription
        : Optional[zio.aws.health.model.EventDescription.ReadOnly]
    def eventMetadata: Optional[Map[MetadataKey, MetadataValue]]
    def getEvent: ZIO[Any, AwsError, zio.aws.health.model.Event.ReadOnly] =
      AwsError.unwrapOptionField("event", event)
    def getEventDescription
        : ZIO[Any, AwsError, zio.aws.health.model.EventDescription.ReadOnly] =
      AwsError.unwrapOptionField("eventDescription", eventDescription)
    def getEventMetadata: ZIO[Any, AwsError, Map[MetadataKey, MetadataValue]] =
      AwsError.unwrapOptionField("eventMetadata", eventMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.EventDetails
  ) extends zio.aws.health.model.EventDetails.ReadOnly {
    override val event: Optional[zio.aws.health.model.Event.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.event())
        .map(value => zio.aws.health.model.Event.wrap(value))
    override val eventDescription
        : Optional[zio.aws.health.model.EventDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventDescription())
        .map(value => zio.aws.health.model.EventDescription.wrap(value))
    override val eventMetadata: Optional[Map[MetadataKey, MetadataValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventMetadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.health.model.primitives.MetadataKey(
                key
              ) -> zio.aws.health.model.primitives.MetadataValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.EventDetails
  ): zio.aws.health.model.EventDetails.ReadOnly = new Wrapper(impl)
}
