package zio.aws.health.model
import zio.aws.health.model.primitives.{
  EntityValue,
  EntityArn,
  TagValue,
  AvailabilityZone,
  Service,
  Region,
  EventArn,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EventFilter(
    eventArns: Optional[Iterable[EventArn]] = Optional.Absent,
    eventTypeCodes: Optional[
      Iterable[zio.aws.health.model.primitives.EventType]
    ] = Optional.Absent,
    services: Optional[Iterable[Service]] = Optional.Absent,
    regions: Optional[Iterable[Region]] = Optional.Absent,
    availabilityZones: Optional[Iterable[AvailabilityZone]] = Optional.Absent,
    startTimes: Optional[Iterable[zio.aws.health.model.DateTimeRange]] =
      Optional.Absent,
    endTimes: Optional[Iterable[zio.aws.health.model.DateTimeRange]] =
      Optional.Absent,
    lastUpdatedTimes: Optional[Iterable[zio.aws.health.model.DateTimeRange]] =
      Optional.Absent,
    entityArns: Optional[Iterable[EntityArn]] = Optional.Absent,
    entityValues: Optional[Iterable[EntityValue]] = Optional.Absent,
    eventTypeCategories: Optional[
      Iterable[zio.aws.health.model.EventTypeCategory]
    ] = Optional.Absent,
    tags: Optional[Iterable[Map[TagKey, TagValue]]] = Optional.Absent,
    eventStatusCodes: Optional[Iterable[zio.aws.health.model.EventStatusCode]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.EventFilter = {
    import EventFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.EventFilter
      .builder()
      .optionallyWith(
        eventArns.map(value =>
          value.map { item =>
            EventArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.eventArns)
      .optionallyWith(
        eventTypeCodes.map(value =>
          value.map { item =>
            zio.aws.health.model.primitives.EventType.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.eventTypeCodes)
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            Service.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.services)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            AvailabilityZone.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        startTimes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.startTimes)
      .optionallyWith(
        endTimes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endTimes)
      .optionallyWith(
        lastUpdatedTimes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lastUpdatedTimes)
      .optionallyWith(
        entityArns.map(value =>
          value.map { item =>
            EntityArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.entityArns)
      .optionallyWith(
        entityValues.map(value =>
          value.map { item =>
            EntityValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.entityValues)
      .optionallyWith(
        eventTypeCategories.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.eventTypeCategoriesWithStrings)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                  value
                ): java.lang.String)
              })
              .asJava
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        eventStatusCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.eventStatusCodesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.health.model.EventFilter.ReadOnly =
    zio.aws.health.model.EventFilter.wrap(buildAwsValue())
}
object EventFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.EventFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.EventFilter =
      zio.aws.health.model.EventFilter(
        eventArns.map(value => value),
        eventTypeCodes.map(value => value),
        services.map(value => value),
        regions.map(value => value),
        availabilityZones.map(value => value),
        startTimes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        endTimes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastUpdatedTimes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        entityArns.map(value => value),
        entityValues.map(value => value),
        eventTypeCategories.map(value => value),
        tags.map(value => value),
        eventStatusCodes.map(value => value)
      )
    def eventArns: Optional[List[EventArn]]
    def eventTypeCodes
        : Optional[List[zio.aws.health.model.primitives.EventType]]
    def services: Optional[List[Service]]
    def regions: Optional[List[Region]]
    def availabilityZones: Optional[List[AvailabilityZone]]
    def startTimes: Optional[List[zio.aws.health.model.DateTimeRange.ReadOnly]]
    def endTimes: Optional[List[zio.aws.health.model.DateTimeRange.ReadOnly]]
    def lastUpdatedTimes
        : Optional[List[zio.aws.health.model.DateTimeRange.ReadOnly]]
    def entityArns: Optional[List[EntityArn]]
    def entityValues: Optional[List[EntityValue]]
    def eventTypeCategories
        : Optional[List[zio.aws.health.model.EventTypeCategory]]
    def tags: Optional[List[Map[TagKey, TagValue]]]
    def eventStatusCodes: Optional[List[zio.aws.health.model.EventStatusCode]]
    def getEventArns: ZIO[Any, AwsError, List[EventArn]] =
      AwsError.unwrapOptionField("eventArns", eventArns)
    def getEventTypeCodes
        : ZIO[Any, AwsError, List[zio.aws.health.model.primitives.EventType]] =
      AwsError.unwrapOptionField("eventTypeCodes", eventTypeCodes)
    def getServices: ZIO[Any, AwsError, List[Service]] =
      AwsError.unwrapOptionField("services", services)
    def getRegions: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("regions", regions)
    def getAvailabilityZones: ZIO[Any, AwsError, List[AvailabilityZone]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getStartTimes: ZIO[Any, AwsError, List[
      zio.aws.health.model.DateTimeRange.ReadOnly
    ]] = AwsError.unwrapOptionField("startTimes", startTimes)
    def getEndTimes: ZIO[Any, AwsError, List[
      zio.aws.health.model.DateTimeRange.ReadOnly
    ]] = AwsError.unwrapOptionField("endTimes", endTimes)
    def getLastUpdatedTimes: ZIO[Any, AwsError, List[
      zio.aws.health.model.DateTimeRange.ReadOnly
    ]] = AwsError.unwrapOptionField("lastUpdatedTimes", lastUpdatedTimes)
    def getEntityArns: ZIO[Any, AwsError, List[EntityArn]] =
      AwsError.unwrapOptionField("entityArns", entityArns)
    def getEntityValues: ZIO[Any, AwsError, List[EntityValue]] =
      AwsError.unwrapOptionField("entityValues", entityValues)
    def getEventTypeCategories
        : ZIO[Any, AwsError, List[zio.aws.health.model.EventTypeCategory]] =
      AwsError.unwrapOptionField("eventTypeCategories", eventTypeCategories)
    def getTags: ZIO[Any, AwsError, List[Map[TagKey, TagValue]]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEventStatusCodes
        : ZIO[Any, AwsError, List[zio.aws.health.model.EventStatusCode]] =
      AwsError.unwrapOptionField("eventStatusCodes", eventStatusCodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.EventFilter
  ) extends zio.aws.health.model.EventFilter.ReadOnly {
    override val eventArns: Optional[List[EventArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.eventArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.health.model.primitives.EventArn(item)
        }.toList
      )
    override val eventTypeCodes
        : Optional[List[zio.aws.health.model.primitives.EventType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventTypeCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.primitives.EventType(item)
          }.toList
        )
    override val services: Optional[List[Service]] = zio.aws.core.internal
      .optionalFromNullable(impl.services())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.health.model.primitives.Service(item)
        }.toList
      )
    override val regions: Optional[List[Region]] = zio.aws.core.internal
      .optionalFromNullable(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.health.model.primitives.Region(item)
        }.toList
      )
    override val availabilityZones: Optional[List[AvailabilityZone]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.primitives.AvailabilityZone(item)
          }.toList
        )
    override val startTimes
        : Optional[List[zio.aws.health.model.DateTimeRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTimes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.DateTimeRange.wrap(item)
          }.toList
        )
    override val endTimes
        : Optional[List[zio.aws.health.model.DateTimeRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endTimes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.DateTimeRange.wrap(item)
          }.toList
        )
    override val lastUpdatedTimes
        : Optional[List[zio.aws.health.model.DateTimeRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.DateTimeRange.wrap(item)
          }.toList
        )
    override val entityArns: Optional[List[EntityArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.entityArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.health.model.primitives.EntityArn(item)
        }.toList
      )
    override val entityValues: Optional[List[EntityValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entityValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.primitives.EntityValue(item)
          }.toList
        )
    override val eventTypeCategories
        : Optional[List[zio.aws.health.model.EventTypeCategory]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventTypeCategories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.EventTypeCategory.wrap(item)
          }.toList
        )
    override val tags: Optional[List[Map[TagKey, TagValue]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            item.asScala
              .map({ case (key, value) =>
                zio.aws.health.model.primitives.TagKey(
                  key
                ) -> zio.aws.health.model.primitives.TagValue(value)
              })
              .toMap
          }.toList
        )
    override val eventStatusCodes
        : Optional[List[zio.aws.health.model.EventStatusCode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventStatusCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.EventStatusCode.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.EventFilter
  ): zio.aws.health.model.EventFilter.ReadOnly = new Wrapper(impl)
}
