package zio.aws.health.model
import scala.jdk.CollectionConverters._
sealed trait EventScopeCode {
  def unwrap: software.amazon.awssdk.services.health.model.EventScopeCode
}
object EventScopeCode {
  def wrap(
      value: software.amazon.awssdk.services.health.model.EventScopeCode
  ): zio.aws.health.model.EventScopeCode = value match {
    case software.amazon.awssdk.services.health.model.EventScopeCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.health.model.EventScopeCode.PUBLIC =>
      val r = PUBLIC
      r
    case software.amazon.awssdk.services.health.model.EventScopeCode.ACCOUNT_SPECIFIC =>
      val r = ACCOUNT_SPECIFIC
      r
    case software.amazon.awssdk.services.health.model.EventScopeCode.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.health.model.EventScopeCode {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EventScopeCode =
      software.amazon.awssdk.services.health.model.EventScopeCode.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLIC extends zio.aws.health.model.EventScopeCode {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EventScopeCode =
      software.amazon.awssdk.services.health.model.EventScopeCode.PUBLIC
  }
  case object ACCOUNT_SPECIFIC extends zio.aws.health.model.EventScopeCode {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EventScopeCode =
      software.amazon.awssdk.services.health.model.EventScopeCode.ACCOUNT_SPECIFIC
  }
  case object NONE extends zio.aws.health.model.EventScopeCode {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EventScopeCode =
      software.amazon.awssdk.services.health.model.EventScopeCode.NONE
  }
}
