package zio.aws.health.model
import scala.jdk.CollectionConverters._
sealed trait EventStatusCode {
  def unwrap: software.amazon.awssdk.services.health.model.EventStatusCode
}
object EventStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.health.model.EventStatusCode
  ): zio.aws.health.model.EventStatusCode = value match {
    case software.amazon.awssdk.services.health.model.EventStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.health.model.EventStatusCode.OPEN =>
      val r = open
      r
    case software.amazon.awssdk.services.health.model.EventStatusCode.CLOSED =>
      val r = closed
      r
    case software.amazon.awssdk.services.health.model.EventStatusCode.UPCOMING =>
      val r = upcoming
      r
  }
  case object unknownToSdkVersion extends zio.aws.health.model.EventStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EventStatusCode =
      software.amazon.awssdk.services.health.model.EventStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object open extends zio.aws.health.model.EventStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EventStatusCode =
      software.amazon.awssdk.services.health.model.EventStatusCode.OPEN
  }
  case object closed extends zio.aws.health.model.EventStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EventStatusCode =
      software.amazon.awssdk.services.health.model.EventStatusCode.CLOSED
  }
  case object upcoming extends zio.aws.health.model.EventStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EventStatusCode =
      software.amazon.awssdk.services.health.model.EventStatusCode.UPCOMING
  }
}
