package zio.aws.health.model
import zio.aws.health.model.primitives.{EventTypeCode, Service}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EventType(
    service: Optional[Service] = Optional.Absent,
    code: Optional[EventTypeCode] = Optional.Absent,
    category: Optional[zio.aws.health.model.EventTypeCategory] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.EventType = {
    import EventType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.EventType
      .builder()
      .optionallyWith(
        service.map(value => Service.unwrap(value): java.lang.String)
      )(_.service)
      .optionallyWith(
        code.map(value => EventTypeCode.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(category.map(value => value.unwrap))(_.category)
      .build()
  }
  def asReadOnly: zio.aws.health.model.EventType.ReadOnly =
    zio.aws.health.model.EventType.wrap(buildAwsValue())
}
object EventType {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.health.model.EventType] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.EventType =
      zio.aws.health.model.EventType(
        service.map(value => value),
        code.map(value => value),
        category.map(value => value)
      )
    def service: Optional[Service]
    def code: Optional[EventTypeCode]
    def category: Optional[zio.aws.health.model.EventTypeCategory]
    def getService: ZIO[Any, AwsError, Service] =
      AwsError.unwrapOptionField("service", service)
    def getCode: ZIO[Any, AwsError, EventTypeCode] =
      AwsError.unwrapOptionField("code", code)
    def getCategory
        : ZIO[Any, AwsError, zio.aws.health.model.EventTypeCategory] =
      AwsError.unwrapOptionField("category", category)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.EventType
  ) extends zio.aws.health.model.EventType.ReadOnly {
    override val service: Optional[Service] = zio.aws.core.internal
      .optionalFromNullable(impl.service())
      .map(value => zio.aws.health.model.primitives.Service(value))
    override val code: Optional[EventTypeCode] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => zio.aws.health.model.primitives.EventTypeCode(value))
    override val category: Optional[zio.aws.health.model.EventTypeCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.category())
        .map(value => zio.aws.health.model.EventTypeCategory.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.EventType
  ): zio.aws.health.model.EventType.ReadOnly = new Wrapper(impl)
}
