package zio.aws.health.model
import scala.jdk.CollectionConverters._
sealed trait EventTypeCategory {
  def unwrap: software.amazon.awssdk.services.health.model.EventTypeCategory
}
object EventTypeCategory {
  def wrap(
      value: software.amazon.awssdk.services.health.model.EventTypeCategory
  ): zio.aws.health.model.EventTypeCategory = value match {
    case software.amazon.awssdk.services.health.model.EventTypeCategory.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.health.model.EventTypeCategory.ISSUE =>
      val r = issue
      r
    case software.amazon.awssdk.services.health.model.EventTypeCategory.ACCOUNT_NOTIFICATION =>
      val r = accountNotification
      r
    case software.amazon.awssdk.services.health.model.EventTypeCategory.SCHEDULED_CHANGE =>
      val r = scheduledChange
      r
    case software.amazon.awssdk.services.health.model.EventTypeCategory.INVESTIGATION =>
      val r = investigation
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.health.model.EventTypeCategory {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EventTypeCategory =
      software.amazon.awssdk.services.health.model.EventTypeCategory.UNKNOWN_TO_SDK_VERSION
  }
  case object issue extends zio.aws.health.model.EventTypeCategory {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EventTypeCategory =
      software.amazon.awssdk.services.health.model.EventTypeCategory.ISSUE
  }
  case object accountNotification
      extends zio.aws.health.model.EventTypeCategory {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EventTypeCategory =
      software.amazon.awssdk.services.health.model.EventTypeCategory.ACCOUNT_NOTIFICATION
  }
  case object scheduledChange extends zio.aws.health.model.EventTypeCategory {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EventTypeCategory =
      software.amazon.awssdk.services.health.model.EventTypeCategory.SCHEDULED_CHANGE
  }
  case object investigation extends zio.aws.health.model.EventTypeCategory {
    override def unwrap
        : software.amazon.awssdk.services.health.model.EventTypeCategory =
      software.amazon.awssdk.services.health.model.EventTypeCategory.INVESTIGATION
  }
}
