package zio.aws.health.model
import zio.aws.health.model.primitives.{Service, EventTypeCode}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EventTypeFilter(
    eventTypeCodes: Optional[Iterable[EventTypeCode]] = Optional.Absent,
    services: Optional[Iterable[Service]] = Optional.Absent,
    eventTypeCategories: Optional[
      Iterable[zio.aws.health.model.EventTypeCategory]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.EventTypeFilter = {
    import EventTypeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.EventTypeFilter
      .builder()
      .optionallyWith(
        eventTypeCodes.map(value =>
          value.map { item =>
            EventTypeCode.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.eventTypeCodes)
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            Service.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.services)
      .optionallyWith(
        eventTypeCategories.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.eventTypeCategoriesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.health.model.EventTypeFilter.ReadOnly =
    zio.aws.health.model.EventTypeFilter.wrap(buildAwsValue())
}
object EventTypeFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.EventTypeFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.EventTypeFilter =
      zio.aws.health.model.EventTypeFilter(
        eventTypeCodes.map(value => value),
        services.map(value => value),
        eventTypeCategories.map(value => value)
      )
    def eventTypeCodes: Optional[List[EventTypeCode]]
    def services: Optional[List[Service]]
    def eventTypeCategories
        : Optional[List[zio.aws.health.model.EventTypeCategory]]
    def getEventTypeCodes: ZIO[Any, AwsError, List[EventTypeCode]] =
      AwsError.unwrapOptionField("eventTypeCodes", eventTypeCodes)
    def getServices: ZIO[Any, AwsError, List[Service]] =
      AwsError.unwrapOptionField("services", services)
    def getEventTypeCategories
        : ZIO[Any, AwsError, List[zio.aws.health.model.EventTypeCategory]] =
      AwsError.unwrapOptionField("eventTypeCategories", eventTypeCategories)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.EventTypeFilter
  ) extends zio.aws.health.model.EventTypeFilter.ReadOnly {
    override val eventTypeCodes: Optional[List[EventTypeCode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventTypeCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.primitives.EventTypeCode(item)
          }.toList
        )
    override val services: Optional[List[Service]] = zio.aws.core.internal
      .optionalFromNullable(impl.services())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.health.model.primitives.Service(item)
        }.toList
      )
    override val eventTypeCategories
        : Optional[List[zio.aws.health.model.EventTypeCategory]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventTypeCategories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.EventTypeCategory.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.EventTypeFilter
  ): zio.aws.health.model.EventTypeFilter.ReadOnly = new Wrapper(impl)
}
