package zio.aws.health.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.health.model.primitives.{
  EventTypeCode,
  Timestamp,
  Service,
  Region,
  EventArn
}
import scala.jdk.CollectionConverters._
final case class OrganizationEvent(
    arn: Optional[EventArn] = Optional.Absent,
    service: Optional[Service] = Optional.Absent,
    eventTypeCode: Optional[EventTypeCode] = Optional.Absent,
    eventTypeCategory: Optional[zio.aws.health.model.EventTypeCategory] =
      Optional.Absent,
    eventScopeCode: Optional[zio.aws.health.model.EventScopeCode] =
      Optional.Absent,
    region: Optional[Region] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    statusCode: Optional[zio.aws.health.model.EventStatusCode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.OrganizationEvent = {
    import OrganizationEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.OrganizationEvent
      .builder()
      .optionallyWith(
        arn.map(value => EventArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        service.map(value => Service.unwrap(value): java.lang.String)
      )(_.service)
      .optionallyWith(
        eventTypeCode.map(value =>
          EventTypeCode.unwrap(value): java.lang.String
        )
      )(_.eventTypeCode)
      .optionallyWith(eventTypeCategory.map(value => value.unwrap))(
        _.eventTypeCategory
      )
      .optionallyWith(eventScopeCode.map(value => value.unwrap))(
        _.eventScopeCode
      )
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .build()
  }
  def asReadOnly: zio.aws.health.model.OrganizationEvent.ReadOnly =
    zio.aws.health.model.OrganizationEvent.wrap(buildAwsValue())
}
object OrganizationEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.OrganizationEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.OrganizationEvent =
      zio.aws.health.model.OrganizationEvent(
        arn.map(value => value),
        service.map(value => value),
        eventTypeCode.map(value => value),
        eventTypeCategory.map(value => value),
        eventScopeCode.map(value => value),
        region.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        lastUpdatedTime.map(value => value),
        statusCode.map(value => value)
      )
    def arn: Optional[EventArn]
    def service: Optional[Service]
    def eventTypeCode: Optional[EventTypeCode]
    def eventTypeCategory: Optional[zio.aws.health.model.EventTypeCategory]
    def eventScopeCode: Optional[zio.aws.health.model.EventScopeCode]
    def region: Optional[Region]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def lastUpdatedTime: Optional[Timestamp]
    def statusCode: Optional[zio.aws.health.model.EventStatusCode]
    def getArn: ZIO[Any, AwsError, EventArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getService: ZIO[Any, AwsError, Service] =
      AwsError.unwrapOptionField("service", service)
    def getEventTypeCode: ZIO[Any, AwsError, EventTypeCode] =
      AwsError.unwrapOptionField("eventTypeCode", eventTypeCode)
    def getEventTypeCategory
        : ZIO[Any, AwsError, zio.aws.health.model.EventTypeCategory] =
      AwsError.unwrapOptionField("eventTypeCategory", eventTypeCategory)
    def getEventScopeCode
        : ZIO[Any, AwsError, zio.aws.health.model.EventScopeCode] =
      AwsError.unwrapOptionField("eventScopeCode", eventScopeCode)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getStatusCode
        : ZIO[Any, AwsError, zio.aws.health.model.EventStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.OrganizationEvent
  ) extends zio.aws.health.model.OrganizationEvent.ReadOnly {
    override val arn: Optional[EventArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.health.model.primitives.EventArn(value))
    override val service: Optional[Service] = zio.aws.core.internal
      .optionalFromNullable(impl.service())
      .map(value => zio.aws.health.model.primitives.Service(value))
    override val eventTypeCode: Optional[EventTypeCode] = zio.aws.core.internal
      .optionalFromNullable(impl.eventTypeCode())
      .map(value => zio.aws.health.model.primitives.EventTypeCode(value))
    override val eventTypeCategory
        : Optional[zio.aws.health.model.EventTypeCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventTypeCategory())
        .map(value => zio.aws.health.model.EventTypeCategory.wrap(value))
    override val eventScopeCode: Optional[zio.aws.health.model.EventScopeCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventScopeCode())
        .map(value => zio.aws.health.model.EventScopeCode.wrap(value))
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.health.model.primitives.Region(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.health.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.health.model.primitives.Timestamp(value))
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.health.model.primitives.Timestamp(value))
    override val statusCode: Optional[zio.aws.health.model.EventStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value => zio.aws.health.model.EventStatusCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.OrganizationEvent
  ): zio.aws.health.model.OrganizationEvent.ReadOnly = new Wrapper(impl)
}
