package zio.aws.health.model
import zio.aws.health.model.primitives.{MetadataValue, MetadataKey, AccountId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OrganizationEventDetails(
    awsAccountId: Optional[AccountId] = Optional.Absent,
    event: Optional[zio.aws.health.model.Event] = Optional.Absent,
    eventDescription: Optional[zio.aws.health.model.EventDescription] =
      Optional.Absent,
    eventMetadata: Optional[Map[MetadataKey, MetadataValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.OrganizationEventDetails = {
    import OrganizationEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.OrganizationEventDetails
      .builder()
      .optionallyWith(
        awsAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(event.map(value => value.buildAwsValue()))(_.event)
      .optionallyWith(eventDescription.map(value => value.buildAwsValue()))(
        _.eventDescription
      )
      .optionallyWith(
        eventMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (MetadataKey.unwrap(key): java.lang.String) -> (MetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.eventMetadata)
      .build()
  }
  def asReadOnly: zio.aws.health.model.OrganizationEventDetails.ReadOnly =
    zio.aws.health.model.OrganizationEventDetails.wrap(buildAwsValue())
}
object OrganizationEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.OrganizationEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.OrganizationEventDetails =
      zio.aws.health.model.OrganizationEventDetails(
        awsAccountId.map(value => value),
        event.map(value => value.asEditable),
        eventDescription.map(value => value.asEditable),
        eventMetadata.map(value => value)
      )
    def awsAccountId: Optional[AccountId]
    def event: Optional[zio.aws.health.model.Event.ReadOnly]
    def eventDescription
        : Optional[zio.aws.health.model.EventDescription.ReadOnly]
    def eventMetadata: Optional[Map[MetadataKey, MetadataValue]]
    def getAwsAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getEvent: ZIO[Any, AwsError, zio.aws.health.model.Event.ReadOnly] =
      AwsError.unwrapOptionField("event", event)
    def getEventDescription
        : ZIO[Any, AwsError, zio.aws.health.model.EventDescription.ReadOnly] =
      AwsError.unwrapOptionField("eventDescription", eventDescription)
    def getEventMetadata: ZIO[Any, AwsError, Map[MetadataKey, MetadataValue]] =
      AwsError.unwrapOptionField("eventMetadata", eventMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.OrganizationEventDetails
  ) extends zio.aws.health.model.OrganizationEventDetails.ReadOnly {
    override val awsAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.health.model.primitives.AccountId(value))
    override val event: Optional[zio.aws.health.model.Event.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.event())
        .map(value => zio.aws.health.model.Event.wrap(value))
    override val eventDescription
        : Optional[zio.aws.health.model.EventDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventDescription())
        .map(value => zio.aws.health.model.EventDescription.wrap(value))
    override val eventMetadata: Optional[Map[MetadataKey, MetadataValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventMetadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.health.model.primitives.MetadataKey(
                key
              ) -> zio.aws.health.model.primitives.MetadataValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.OrganizationEventDetails
  ): zio.aws.health.model.OrganizationEventDetails.ReadOnly = new Wrapper(impl)
}
