package zio.aws.health.model
import zio.aws.health.model.primitives.{EventArn, AccountId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OrganizationEventDetailsErrorItem(
    awsAccountId: Optional[AccountId] = Optional.Absent,
    eventArn: Optional[EventArn] = Optional.Absent,
    errorName: Optional[String] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.OrganizationEventDetailsErrorItem = {
    import OrganizationEventDetailsErrorItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.OrganizationEventDetailsErrorItem
      .builder()
      .optionallyWith(
        awsAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(
        eventArn.map(value => EventArn.unwrap(value): java.lang.String)
      )(_.eventArn)
      .optionallyWith(errorName.map(value => value: java.lang.String))(
        _.errorName
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.health.model.OrganizationEventDetailsErrorItem.ReadOnly =
    zio.aws.health.model.OrganizationEventDetailsErrorItem.wrap(buildAwsValue())
}
object OrganizationEventDetailsErrorItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.OrganizationEventDetailsErrorItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.OrganizationEventDetailsErrorItem =
      zio.aws.health.model.OrganizationEventDetailsErrorItem(
        awsAccountId.map(value => value),
        eventArn.map(value => value),
        errorName.map(value => value),
        errorMessage.map(value => value)
      )
    def awsAccountId: Optional[AccountId]
    def eventArn: Optional[EventArn]
    def errorName: Optional[String]
    def errorMessage: Optional[String]
    def getAwsAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getEventArn: ZIO[Any, AwsError, EventArn] =
      AwsError.unwrapOptionField("eventArn", eventArn)
    def getErrorName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorName", errorName)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.OrganizationEventDetailsErrorItem
  ) extends zio.aws.health.model.OrganizationEventDetailsErrorItem.ReadOnly {
    override val awsAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.health.model.primitives.AccountId(value))
    override val eventArn: Optional[EventArn] = zio.aws.core.internal
      .optionalFromNullable(impl.eventArn())
      .map(value => zio.aws.health.model.primitives.EventArn(value))
    override val errorName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorName())
      .map(value => value: String)
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.OrganizationEventDetailsErrorItem
  ): zio.aws.health.model.OrganizationEventDetailsErrorItem.ReadOnly =
    new Wrapper(impl)
}
