package zio.aws.health.model
import zio.aws.health.model.primitives.{
  EntityValue,
  AccountId,
  EntityArn,
  Service,
  Region
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OrganizationEventFilter(
    eventTypeCodes: Optional[
      Iterable[zio.aws.health.model.primitives.EventType]
    ] = Optional.Absent,
    awsAccountIds: Optional[Iterable[AccountId]] = Optional.Absent,
    services: Optional[Iterable[Service]] = Optional.Absent,
    regions: Optional[Iterable[Region]] = Optional.Absent,
    startTime: Optional[zio.aws.health.model.DateTimeRange] = Optional.Absent,
    endTime: Optional[zio.aws.health.model.DateTimeRange] = Optional.Absent,
    lastUpdatedTime: Optional[zio.aws.health.model.DateTimeRange] =
      Optional.Absent,
    entityArns: Optional[Iterable[EntityArn]] = Optional.Absent,
    entityValues: Optional[Iterable[EntityValue]] = Optional.Absent,
    eventTypeCategories: Optional[
      Iterable[zio.aws.health.model.EventTypeCategory]
    ] = Optional.Absent,
    eventStatusCodes: Optional[Iterable[zio.aws.health.model.EventStatusCode]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.OrganizationEventFilter = {
    import OrganizationEventFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.OrganizationEventFilter
      .builder()
      .optionallyWith(
        eventTypeCodes.map(value =>
          value.map { item =>
            zio.aws.health.model.primitives.EventType.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.eventTypeCodes)
      .optionallyWith(
        awsAccountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.awsAccountIds)
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            Service.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.services)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .optionallyWith(startTime.map(value => value.buildAwsValue()))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => value.buildAwsValue()))(_.endTime)
      .optionallyWith(lastUpdatedTime.map(value => value.buildAwsValue()))(
        _.lastUpdatedTime
      )
      .optionallyWith(
        entityArns.map(value =>
          value.map { item =>
            EntityArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.entityArns)
      .optionallyWith(
        entityValues.map(value =>
          value.map { item =>
            EntityValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.entityValues)
      .optionallyWith(
        eventTypeCategories.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.eventTypeCategoriesWithStrings)
      .optionallyWith(
        eventStatusCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.eventStatusCodesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.health.model.OrganizationEventFilter.ReadOnly =
    zio.aws.health.model.OrganizationEventFilter.wrap(buildAwsValue())
}
object OrganizationEventFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.OrganizationEventFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.OrganizationEventFilter =
      zio.aws.health.model.OrganizationEventFilter(
        eventTypeCodes.map(value => value),
        awsAccountIds.map(value => value),
        services.map(value => value),
        regions.map(value => value),
        startTime.map(value => value.asEditable),
        endTime.map(value => value.asEditable),
        lastUpdatedTime.map(value => value.asEditable),
        entityArns.map(value => value),
        entityValues.map(value => value),
        eventTypeCategories.map(value => value),
        eventStatusCodes.map(value => value)
      )
    def eventTypeCodes
        : Optional[List[zio.aws.health.model.primitives.EventType]]
    def awsAccountIds: Optional[List[AccountId]]
    def services: Optional[List[Service]]
    def regions: Optional[List[Region]]
    def startTime: Optional[zio.aws.health.model.DateTimeRange.ReadOnly]
    def endTime: Optional[zio.aws.health.model.DateTimeRange.ReadOnly]
    def lastUpdatedTime: Optional[zio.aws.health.model.DateTimeRange.ReadOnly]
    def entityArns: Optional[List[EntityArn]]
    def entityValues: Optional[List[EntityValue]]
    def eventTypeCategories
        : Optional[List[zio.aws.health.model.EventTypeCategory]]
    def eventStatusCodes: Optional[List[zio.aws.health.model.EventStatusCode]]
    def getEventTypeCodes
        : ZIO[Any, AwsError, List[zio.aws.health.model.primitives.EventType]] =
      AwsError.unwrapOptionField("eventTypeCodes", eventTypeCodes)
    def getAwsAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("awsAccountIds", awsAccountIds)
    def getServices: ZIO[Any, AwsError, List[Service]] =
      AwsError.unwrapOptionField("services", services)
    def getRegions: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("regions", regions)
    def getStartTime
        : ZIO[Any, AwsError, zio.aws.health.model.DateTimeRange.ReadOnly] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime
        : ZIO[Any, AwsError, zio.aws.health.model.DateTimeRange.ReadOnly] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getLastUpdatedTime
        : ZIO[Any, AwsError, zio.aws.health.model.DateTimeRange.ReadOnly] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getEntityArns: ZIO[Any, AwsError, List[EntityArn]] =
      AwsError.unwrapOptionField("entityArns", entityArns)
    def getEntityValues: ZIO[Any, AwsError, List[EntityValue]] =
      AwsError.unwrapOptionField("entityValues", entityValues)
    def getEventTypeCategories
        : ZIO[Any, AwsError, List[zio.aws.health.model.EventTypeCategory]] =
      AwsError.unwrapOptionField("eventTypeCategories", eventTypeCategories)
    def getEventStatusCodes
        : ZIO[Any, AwsError, List[zio.aws.health.model.EventStatusCode]] =
      AwsError.unwrapOptionField("eventStatusCodes", eventStatusCodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.OrganizationEventFilter
  ) extends zio.aws.health.model.OrganizationEventFilter.ReadOnly {
    override val eventTypeCodes
        : Optional[List[zio.aws.health.model.primitives.EventType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventTypeCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.primitives.EventType(item)
          }.toList
        )
    override val awsAccountIds: Optional[List[AccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsAccountIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.primitives.AccountId(item)
          }.toList
        )
    override val services: Optional[List[Service]] = zio.aws.core.internal
      .optionalFromNullable(impl.services())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.health.model.primitives.Service(item)
        }.toList
      )
    override val regions: Optional[List[Region]] = zio.aws.core.internal
      .optionalFromNullable(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.health.model.primitives.Region(item)
        }.toList
      )
    override val startTime
        : Optional[zio.aws.health.model.DateTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTime())
        .map(value => zio.aws.health.model.DateTimeRange.wrap(value))
    override val endTime
        : Optional[zio.aws.health.model.DateTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endTime())
        .map(value => zio.aws.health.model.DateTimeRange.wrap(value))
    override val lastUpdatedTime
        : Optional[zio.aws.health.model.DateTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTime())
        .map(value => zio.aws.health.model.DateTimeRange.wrap(value))
    override val entityArns: Optional[List[EntityArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.entityArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.health.model.primitives.EntityArn(item)
        }.toList
      )
    override val entityValues: Optional[List[EntityValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entityValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.primitives.EntityValue(item)
          }.toList
        )
    override val eventTypeCategories
        : Optional[List[zio.aws.health.model.EventTypeCategory]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventTypeCategories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.EventTypeCategory.wrap(item)
          }.toList
        )
    override val eventStatusCodes
        : Optional[List[zio.aws.health.model.EventStatusCode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventStatusCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.EventStatusCode.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.OrganizationEventFilter
  ): zio.aws.health.model.OrganizationEventFilter.ReadOnly = new Wrapper(impl)
}
