package zio.aws.health
import zio.aws.health.model.primitives.{
  EntityValue,
  EventTypeCode,
  AccountId,
  EntityArn,
  TagValue,
  AvailabilityZone,
  Service,
  Region,
  EventArn,
  MetadataValue,
  MetadataKey,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.health.model.primitives.Service.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.health.model.primitives.AccountId.Type
    object AggregateValue extends Subtype[String]
    type AggregateValue = zio.aws.health.model.primitives.AggregateValue.Type
    object AvailabilityZone extends Subtype[String]
    type AvailabilityZone =
      zio.aws.health.model.primitives.AvailabilityZone.Type
    object Count extends Subtype[Int]
    type Count = zio.aws.health.model.primitives.Count.Type
    object EntityArn extends Subtype[String]
    type EntityArn = zio.aws.health.model.primitives.EntityArn.Type
    object EntityUrl extends Subtype[String]
    type EntityUrl = zio.aws.health.model.primitives.EntityUrl.Type
    object EntityValue extends Subtype[String]
    type EntityValue = zio.aws.health.model.primitives.EntityValue.Type
    object EventArn extends Subtype[String]
    type EventArn = zio.aws.health.model.primitives.EventArn.Type
    object EventDescription extends Subtype[String]
    type EventDescription =
      zio.aws.health.model.primitives.EventDescription.Type
    object EventType extends Subtype[String]
    type EventType = zio.aws.health.model.primitives.EventType.Type
    object EventTypeCode extends Subtype[String]
    type EventTypeCode = zio.aws.health.model.primitives.EventTypeCode.Type
    object HealthServiceAccessStatusForOrganization extends Subtype[String]
    type HealthServiceAccessStatusForOrganization =
      zio.aws.health.model.primitives.HealthServiceAccessStatusForOrganization.Type
    object Locale extends Subtype[String]
    type Locale = zio.aws.health.model.primitives.Locale.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.health.model.primitives.MaxResults.Type
    object MaxResultsLowerRange extends Subtype[Int]
    type MaxResultsLowerRange =
      zio.aws.health.model.primitives.MaxResultsLowerRange.Type
    object MetadataKey extends Subtype[String]
    type MetadataKey = zio.aws.health.model.primitives.MetadataKey.Type
    object MetadataValue extends Subtype[String]
    type MetadataValue = zio.aws.health.model.primitives.MetadataValue.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.health.model.primitives.NextToken.Type
    object Region extends Subtype[String]
    type Region = zio.aws.health.model.primitives.Region.Type
    object Service extends Subtype[String]
    type Service = zio.aws.health.model.primitives.Service.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.health.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.health.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.health.model.primitives.Timestamp.Type
  }
  type AffectedAccountsList = List[AccountId]
  type AvailabilityZones = List[AvailabilityZone]
  type AwsAccountIdsList = List[AccountId]
  type DateTimeRangeList = List[zio.aws.health.model.DateTimeRange]
  type DescribeAffectedEntitiesForOrganizationFailedSet =
    List[zio.aws.health.model.OrganizationAffectedEntitiesErrorItem]
  type DescribeEventDetailsFailedSet =
    List[zio.aws.health.model.EventDetailsErrorItem]
  type DescribeEventDetailsForOrganizationFailedSet =
    List[zio.aws.health.model.OrganizationEventDetailsErrorItem]
  type DescribeEventDetailsForOrganizationSuccessfulSet =
    List[zio.aws.health.model.OrganizationEventDetails]
  type DescribeEventDetailsSuccessfulSet =
    List[zio.aws.health.model.EventDetails]
  type EntityAggregateList = List[zio.aws.health.model.EntityAggregate]
  type EntityArnList = List[EntityArn]
  type EntityList = List[zio.aws.health.model.AffectedEntity]
  type EntityStatusCodeList = List[zio.aws.health.model.EntityStatusCode]
  type EntityValueList = List[EntityValue]
  type EventAggregateList = List[zio.aws.health.model.EventAggregate]
  type EventArnList = List[EventArn]
  type EventArnsList = List[EventArn]
  type EventList = List[zio.aws.health.model.Event]
  type EventMetadata = Map[MetadataKey, MetadataValue]
  type EventStatusCodeList = List[zio.aws.health.model.EventStatusCode]
  type EventTypeCategoryList = List[zio.aws.health.model.EventTypeCategory]
  type EventTypeCodeList = List[EventTypeCode]
  type EventTypeList = List[zio.aws.health.model.primitives.EventType]
  type OrganizationEntityFiltersList =
    List[zio.aws.health.model.EventAccountFilter]
  type OrganizationEventDetailFiltersList =
    List[zio.aws.health.model.EventAccountFilter]
  type OrganizationEventList = List[zio.aws.health.model.OrganizationEvent]
  type RegionList = List[Region]
  type ServiceList = List[Service]
  type TagFilter = List[Map[TagKey, TagValue]]
  type TagSet = Map[TagKey, TagValue]
}
