package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.WorkbookCursor
import scala.jdk.CollectionConverters._
final case class BatchDeleteTableRowsResponse(
    workbookCursor: WorkbookCursor,
    failedBatchItems: Option[
      Iterable[zio.aws.honeycode.model.FailedBatchItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsResponse = {
    import BatchDeleteTableRowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsResponse
      .builder()
      .workbookCursor(WorkbookCursor.unwrap(workbookCursor): java.lang.Long)
      .optionallyWith(
        failedBatchItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedBatchItems)
      .build()
  }
  def asReadOnly
      : zio.aws.honeycode.model.BatchDeleteTableRowsResponse.ReadOnly =
    zio.aws.honeycode.model.BatchDeleteTableRowsResponse.wrap(buildAwsValue())
}
object BatchDeleteTableRowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.BatchDeleteTableRowsResponse =
      zio.aws.honeycode.model.BatchDeleteTableRowsResponse(
        workbookCursor,
        failedBatchItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def workbookCursor: WorkbookCursor
    def failedBatchItems
        : Option[List[zio.aws.honeycode.model.FailedBatchItem.ReadOnly]]
    def getWorkbookCursor: ZIO[Any, Nothing, WorkbookCursor] =
      ZIO.succeed(workbookCursor)
    def getFailedBatchItems: ZIO[Any, AwsError, List[
      zio.aws.honeycode.model.FailedBatchItem.ReadOnly
    ]] = AwsError.unwrapOptionField("failedBatchItems", failedBatchItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsResponse
  ) extends zio.aws.honeycode.model.BatchDeleteTableRowsResponse.ReadOnly {
    override val workbookCursor: WorkbookCursor =
      zio.aws.honeycode.model.primitives.WorkbookCursor(impl.workbookCursor())
    override val failedBatchItems
        : Option[List[zio.aws.honeycode.model.FailedBatchItem.ReadOnly]] = scala
      .Option(impl.failedBatchItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.honeycode.model.FailedBatchItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsResponse
  ): zio.aws.honeycode.model.BatchDeleteTableRowsResponse.ReadOnly =
    new Wrapper(impl)
}
