package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.{ClientRequestToken, ResourceId}
import scala.jdk.CollectionConverters._
final case class BatchUpsertTableRowsRequest(
    workbookId: ResourceId,
    tableId: ResourceId,
    rowsToUpsert: Iterable[zio.aws.honeycode.model.UpsertRowData],
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsRequest = {
    import BatchUpsertTableRowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsRequest
      .builder()
      .workbookId(ResourceId.unwrap(workbookId): java.lang.String)
      .tableId(ResourceId.unwrap(tableId): java.lang.String)
      .rowsToUpsert(rowsToUpsert.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.BatchUpsertTableRowsRequest.ReadOnly =
    zio.aws.honeycode.model.BatchUpsertTableRowsRequest.wrap(buildAwsValue())
}
object BatchUpsertTableRowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.BatchUpsertTableRowsRequest =
      zio.aws.honeycode.model.BatchUpsertTableRowsRequest(
        workbookId,
        tableId,
        rowsToUpsert.map { item =>
          item.asEditable
        },
        clientRequestToken.map(value => value)
      )
    def workbookId: ResourceId
    def tableId: ResourceId
    def rowsToUpsert: List[zio.aws.honeycode.model.UpsertRowData.ReadOnly]
    def clientRequestToken: Option[ClientRequestToken]
    def getWorkbookId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(workbookId)
    def getTableId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(tableId)
    def getRowsToUpsert: ZIO[Any, Nothing, List[
      zio.aws.honeycode.model.UpsertRowData.ReadOnly
    ]] = ZIO.succeed(rowsToUpsert)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsRequest
  ) extends zio.aws.honeycode.model.BatchUpsertTableRowsRequest.ReadOnly {
    override val workbookId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.workbookId())
    override val tableId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.tableId())
    override val rowsToUpsert
        : List[zio.aws.honeycode.model.UpsertRowData.ReadOnly] = impl
      .rowsToUpsert()
      .asScala
      .map { item =>
        zio.aws.honeycode.model.UpsertRowData.wrap(item)
      }
      .toList
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.honeycode.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsRequest
  ): zio.aws.honeycode.model.BatchUpsertTableRowsRequest.ReadOnly = new Wrapper(
    impl
  )
}
