package zio.aws.honeycode.model
import scala.jdk.CollectionConverters._
sealed trait UpsertAction {
  def unwrap: software.amazon.awssdk.services.honeycode.model.UpsertAction
}
object UpsertAction {
  def wrap(
      value: software.amazon.awssdk.services.honeycode.model.UpsertAction
  ): zio.aws.honeycode.model.UpsertAction = value match {
    case software.amazon.awssdk.services.honeycode.model.UpsertAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.honeycode.model.UpsertAction.UPDATED =>
      val r = UPDATED
      r
    case software.amazon.awssdk.services.honeycode.model.UpsertAction.APPENDED =>
      val r = APPENDED
      r
  }
  case object unknownToSdkVersion extends zio.aws.honeycode.model.UpsertAction {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.UpsertAction =
      software.amazon.awssdk.services.honeycode.model.UpsertAction.UNKNOWN_TO_SDK_VERSION
  }
  case object UPDATED extends zio.aws.honeycode.model.UpsertAction {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.UpsertAction =
      software.amazon.awssdk.services.honeycode.model.UpsertAction.UPDATED
  }
  case object APPENDED extends zio.aws.honeycode.model.UpsertAction {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.UpsertAction =
      software.amazon.awssdk.services.honeycode.model.UpsertAction.APPENDED
  }
}
