package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.honeycode.model.primitives.Name
import scala.jdk.CollectionConverters._
final case class ColumnMetadata(
    name: Name,
    format: zio.aws.honeycode.model.Format
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.ColumnMetadata = {
    import ColumnMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.ColumnMetadata
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .format(format.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.ColumnMetadata.ReadOnly =
    zio.aws.honeycode.model.ColumnMetadata.wrap(buildAwsValue())
}
object ColumnMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.ColumnMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.ColumnMetadata =
      zio.aws.honeycode.model.ColumnMetadata(name, format)
    def name: Name
    def format: zio.aws.honeycode.model.Format
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getFormat: ZIO[Any, Nothing, zio.aws.honeycode.model.Format] =
      ZIO.succeed(format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.ColumnMetadata
  ) extends zio.aws.honeycode.model.ColumnMetadata.ReadOnly {
    override val name: Name =
      zio.aws.honeycode.model.primitives.Name(impl.name())
    override val format: zio.aws.honeycode.model.Format =
      zio.aws.honeycode.model.Format.wrap(impl.format())
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.ColumnMetadata
  ): zio.aws.honeycode.model.ColumnMetadata.ReadOnly = new Wrapper(impl)
}
