package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.honeycode.model.primitives.{WorkbookCursor, PaginationToken}
import scala.jdk.CollectionConverters._
final case class ListTableColumnsResponse(
    tableColumns: Iterable[zio.aws.honeycode.model.TableColumn],
    nextToken: Optional[PaginationToken] = Optional.Absent,
    workbookCursor: Optional[WorkbookCursor] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse = {
    import ListTableColumnsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse
      .builder()
      .tableColumns(tableColumns.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        workbookCursor.map(value =>
          WorkbookCursor.unwrap(value): java.lang.Long
        )
      )(_.workbookCursor)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.ListTableColumnsResponse.ReadOnly =
    zio.aws.honeycode.model.ListTableColumnsResponse.wrap(buildAwsValue())
}
object ListTableColumnsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.ListTableColumnsResponse =
      zio.aws.honeycode.model.ListTableColumnsResponse(
        tableColumns.map { item =>
          item.asEditable
        },
        nextToken.map(value => value),
        workbookCursor.map(value => value)
      )
    def tableColumns: List[zio.aws.honeycode.model.TableColumn.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def workbookCursor: Optional[WorkbookCursor]
    def getTableColumns: ZIO[Any, Nothing, List[
      zio.aws.honeycode.model.TableColumn.ReadOnly
    ]] = ZIO.succeed(tableColumns)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkbookCursor: ZIO[Any, AwsError, WorkbookCursor] =
      AwsError.unwrapOptionField("workbookCursor", workbookCursor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse
  ) extends zio.aws.honeycode.model.ListTableColumnsResponse.ReadOnly {
    override val tableColumns
        : List[zio.aws.honeycode.model.TableColumn.ReadOnly] = impl
      .tableColumns()
      .asScala
      .map { item =>
        zio.aws.honeycode.model.TableColumn.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.honeycode.model.primitives.PaginationToken(value))
    override val workbookCursor: Optional[WorkbookCursor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workbookCursor())
        .map(value => zio.aws.honeycode.model.primitives.WorkbookCursor(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse
  ): zio.aws.honeycode.model.ListTableColumnsResponse.ReadOnly = new Wrapper(
    impl
  )
}
