package zio.aws.honeycode.model
import scala.jdk.CollectionConverters._
sealed trait ErrorCode {
  def unwrap: software.amazon.awssdk.services.honeycode.model.ErrorCode
}
object ErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.honeycode.model.ErrorCode
  ): zio.aws.honeycode.model.ErrorCode = value match {
    case software.amazon.awssdk.services.honeycode.model.ErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.honeycode.model.ErrorCode.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
    case software.amazon.awssdk.services.honeycode.model.ErrorCode.INVALID_URL_ERROR =>
      val r = INVALID_URL_ERROR
      r
    case software.amazon.awssdk.services.honeycode.model.ErrorCode.INVALID_IMPORT_OPTIONS_ERROR =>
      val r = INVALID_IMPORT_OPTIONS_ERROR
      r
    case software.amazon.awssdk.services.honeycode.model.ErrorCode.INVALID_TABLE_ID_ERROR =>
      val r = INVALID_TABLE_ID_ERROR
      r
    case software.amazon.awssdk.services.honeycode.model.ErrorCode.INVALID_TABLE_COLUMN_ID_ERROR =>
      val r = INVALID_TABLE_COLUMN_ID_ERROR
      r
    case software.amazon.awssdk.services.honeycode.model.ErrorCode.TABLE_NOT_FOUND_ERROR =>
      val r = TABLE_NOT_FOUND_ERROR
      r
    case software.amazon.awssdk.services.honeycode.model.ErrorCode.FILE_EMPTY_ERROR =>
      val r = FILE_EMPTY_ERROR
      r
    case software.amazon.awssdk.services.honeycode.model.ErrorCode.INVALID_FILE_TYPE_ERROR =>
      val r = INVALID_FILE_TYPE_ERROR
      r
    case software.amazon.awssdk.services.honeycode.model.ErrorCode.FILE_PARSING_ERROR =>
      val r = FILE_PARSING_ERROR
      r
    case software.amazon.awssdk.services.honeycode.model.ErrorCode.FILE_SIZE_LIMIT_ERROR =>
      val r = FILE_SIZE_LIMIT_ERROR
      r
    case software.amazon.awssdk.services.honeycode.model.ErrorCode.FILE_NOT_FOUND_ERROR =>
      val r = FILE_NOT_FOUND_ERROR
      r
    case software.amazon.awssdk.services.honeycode.model.ErrorCode.UNKNOWN_ERROR =>
      val r = UNKNOWN_ERROR
      r
    case software.amazon.awssdk.services.honeycode.model.ErrorCode.RESOURCE_NOT_FOUND_ERROR =>
      val r = RESOURCE_NOT_FOUND_ERROR
      r
    case software.amazon.awssdk.services.honeycode.model.ErrorCode.SYSTEM_LIMIT_ERROR =>
      val r = SYSTEM_LIMIT_ERROR
      r
  }
  case object unknownToSdkVersion extends zio.aws.honeycode.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ErrorCode =
      software.amazon.awssdk.services.honeycode.model.ErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCESS_DENIED extends zio.aws.honeycode.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ErrorCode =
      software.amazon.awssdk.services.honeycode.model.ErrorCode.ACCESS_DENIED
  }
  case object INVALID_URL_ERROR extends zio.aws.honeycode.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ErrorCode =
      software.amazon.awssdk.services.honeycode.model.ErrorCode.INVALID_URL_ERROR
  }
  case object INVALID_IMPORT_OPTIONS_ERROR
      extends zio.aws.honeycode.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ErrorCode =
      software.amazon.awssdk.services.honeycode.model.ErrorCode.INVALID_IMPORT_OPTIONS_ERROR
  }
  case object INVALID_TABLE_ID_ERROR extends zio.aws.honeycode.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ErrorCode =
      software.amazon.awssdk.services.honeycode.model.ErrorCode.INVALID_TABLE_ID_ERROR
  }
  case object INVALID_TABLE_COLUMN_ID_ERROR
      extends zio.aws.honeycode.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ErrorCode =
      software.amazon.awssdk.services.honeycode.model.ErrorCode.INVALID_TABLE_COLUMN_ID_ERROR
  }
  case object TABLE_NOT_FOUND_ERROR extends zio.aws.honeycode.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ErrorCode =
      software.amazon.awssdk.services.honeycode.model.ErrorCode.TABLE_NOT_FOUND_ERROR
  }
  case object FILE_EMPTY_ERROR extends zio.aws.honeycode.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ErrorCode =
      software.amazon.awssdk.services.honeycode.model.ErrorCode.FILE_EMPTY_ERROR
  }
  case object INVALID_FILE_TYPE_ERROR
      extends zio.aws.honeycode.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ErrorCode =
      software.amazon.awssdk.services.honeycode.model.ErrorCode.INVALID_FILE_TYPE_ERROR
  }
  case object FILE_PARSING_ERROR extends zio.aws.honeycode.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ErrorCode =
      software.amazon.awssdk.services.honeycode.model.ErrorCode.FILE_PARSING_ERROR
  }
  case object FILE_SIZE_LIMIT_ERROR extends zio.aws.honeycode.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ErrorCode =
      software.amazon.awssdk.services.honeycode.model.ErrorCode.FILE_SIZE_LIMIT_ERROR
  }
  case object FILE_NOT_FOUND_ERROR extends zio.aws.honeycode.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ErrorCode =
      software.amazon.awssdk.services.honeycode.model.ErrorCode.FILE_NOT_FOUND_ERROR
  }
  case object UNKNOWN_ERROR extends zio.aws.honeycode.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ErrorCode =
      software.amazon.awssdk.services.honeycode.model.ErrorCode.UNKNOWN_ERROR
  }
  case object RESOURCE_NOT_FOUND_ERROR
      extends zio.aws.honeycode.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ErrorCode =
      software.amazon.awssdk.services.honeycode.model.ErrorCode.RESOURCE_NOT_FOUND_ERROR
  }
  case object SYSTEM_LIMIT_ERROR extends zio.aws.honeycode.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ErrorCode =
      software.amazon.awssdk.services.honeycode.model.ErrorCode.SYSTEM_LIMIT_ERROR
  }
}
