package zio.aws.honeycode.model
import scala.jdk.CollectionConverters._
sealed trait ImportDataCharacterEncoding {
  def unwrap: software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding
}
object ImportDataCharacterEncoding {
  def wrap(
      value: software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding
  ): zio.aws.honeycode.model.ImportDataCharacterEncoding = value match {
    case software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding.UTF_8 =>
      val r = `UTF-8`
      r
    case software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding.US_ASCII =>
      val r = `US-ASCII`
      r
    case software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding.ISO_8859_1 =>
      val r = `ISO-8859-1`
      r
    case software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding.UTF_16_BE =>
      val r = `UTF-16BE`
      r
    case software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding.UTF_16_LE =>
      val r = `UTF-16LE`
      r
    case software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding.UTF_16 =>
      val r = `UTF-16`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.honeycode.model.ImportDataCharacterEncoding {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding =
      software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding.UNKNOWN_TO_SDK_VERSION
  }
  case object `UTF-8`
      extends zio.aws.honeycode.model.ImportDataCharacterEncoding {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding =
      software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding.UTF_8
  }
  case object `US-ASCII`
      extends zio.aws.honeycode.model.ImportDataCharacterEncoding {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding =
      software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding.US_ASCII
  }
  case object `ISO-8859-1`
      extends zio.aws.honeycode.model.ImportDataCharacterEncoding {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding =
      software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding.ISO_8859_1
  }
  case object `UTF-16BE`
      extends zio.aws.honeycode.model.ImportDataCharacterEncoding {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding =
      software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding.UTF_16_BE
  }
  case object `UTF-16LE`
      extends zio.aws.honeycode.model.ImportDataCharacterEncoding {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding =
      software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding.UTF_16_LE
  }
  case object `UTF-16`
      extends zio.aws.honeycode.model.ImportDataCharacterEncoding {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding =
      software.amazon.awssdk.services.honeycode.model.ImportDataCharacterEncoding.UTF_16
  }
}
