package zio.aws.honeycode
import zio.aws.honeycode.model.ListTableRowsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.honeycode.model.{
  BatchUpsertTableRowsRequest,
  StartTableDataImportJobRequest,
  ListTableColumnsRequest,
  InvokeScreenAutomationRequest,
  BatchDeleteTableRowsRequest,
  DescribeTableDataImportJobRequest,
  ListTagsForResourceRequest,
  GetScreenDataRequest,
  BatchUpdateTableRowsRequest,
  ListTableRowsRequest,
  UntagResourceRequest,
  BatchCreateTableRowsRequest,
  QueryTableRowsRequest,
  ListTablesRequest,
  TagResourceRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.honeycode.HoneycodeAsyncClient
object HoneycodeMock extends Mock[Honeycode] {
  object ListTableColumns
      extends Stream[
        ListTableColumnsRequest,
        AwsError,
        zio.aws.honeycode.model.TableColumn.ReadOnly
      ]
  object ListTableColumnsPaginated
      extends Effect[
        ListTableColumnsRequest,
        AwsError,
        zio.aws.honeycode.model.ListTableColumnsResponse.ReadOnly
      ]
  object BatchCreateTableRows
      extends Effect[
        BatchCreateTableRowsRequest,
        AwsError,
        zio.aws.honeycode.model.BatchCreateTableRowsResponse.ReadOnly
      ]
  object ListTableRows
      extends Stream[
        ListTableRowsRequest,
        AwsError,
        zio.aws.honeycode.model.TableRow.ReadOnly
      ]
  object ListTableRowsPaginated
      extends Effect[ListTableRowsRequest, AwsError, ReadOnly]
  object BatchUpsertTableRows
      extends Effect[
        BatchUpsertTableRowsRequest,
        AwsError,
        zio.aws.honeycode.model.BatchUpsertTableRowsResponse.ReadOnly
      ]
  object DescribeTableDataImportJob
      extends Effect[
        DescribeTableDataImportJobRequest,
        AwsError,
        zio.aws.honeycode.model.DescribeTableDataImportJobResponse.ReadOnly
      ]
  object QueryTableRows
      extends Stream[
        QueryTableRowsRequest,
        AwsError,
        zio.aws.honeycode.model.TableRow.ReadOnly
      ]
  object QueryTableRowsPaginated
      extends Effect[
        QueryTableRowsRequest,
        AwsError,
        zio.aws.honeycode.model.QueryTableRowsResponse.ReadOnly
      ]
  object ListTables
      extends Stream[
        ListTablesRequest,
        AwsError,
        zio.aws.honeycode.model.Table.ReadOnly
      ]
  object ListTablesPaginated
      extends Effect[
        ListTablesRequest,
        AwsError,
        zio.aws.honeycode.model.ListTablesResponse.ReadOnly
      ]
  object GetScreenData
      extends Effect[
        GetScreenDataRequest,
        AwsError,
        zio.aws.honeycode.model.GetScreenDataResponse.ReadOnly
      ]
  object StartTableDataImportJob
      extends Effect[
        StartTableDataImportJobRequest,
        AwsError,
        zio.aws.honeycode.model.StartTableDataImportJobResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.honeycode.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.honeycode.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.honeycode.model.TagResourceResponse.ReadOnly
      ]
  object BatchUpdateTableRows
      extends Effect[
        BatchUpdateTableRowsRequest,
        AwsError,
        zio.aws.honeycode.model.BatchUpdateTableRowsResponse.ReadOnly
      ]
  object BatchDeleteTableRows
      extends Effect[
        BatchDeleteTableRowsRequest,
        AwsError,
        zio.aws.honeycode.model.BatchDeleteTableRowsResponse.ReadOnly
      ]
  object InvokeScreenAutomation
      extends Effect[
        InvokeScreenAutomationRequest,
        AwsError,
        zio.aws.honeycode.model.InvokeScreenAutomationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Honeycode] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Honeycode] { rts =>
        zio.ZIO.succeed {
          new Honeycode {
            val api: HoneycodeAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Honeycode = this
            def listTableColumns(request: ListTableColumnsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.honeycode.model.TableColumn.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTableColumns, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTableColumnsPaginated(request: ListTableColumnsRequest): IO[
              AwsError,
              zio.aws.honeycode.model.ListTableColumnsResponse.ReadOnly
            ] = proxy(ListTableColumnsPaginated, request)
            def batchCreateTableRows(request: BatchCreateTableRowsRequest): IO[
              AwsError,
              zio.aws.honeycode.model.BatchCreateTableRowsResponse.ReadOnly
            ] = proxy(BatchCreateTableRows, request)
            def listTableRows(request: ListTableRowsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.honeycode.model.TableRow.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTableRows, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTableRowsPaginated(
                request: ListTableRowsRequest
            ): IO[AwsError, ReadOnly] = proxy(ListTableRowsPaginated, request)
            def batchUpsertTableRows(request: BatchUpsertTableRowsRequest): IO[
              AwsError,
              zio.aws.honeycode.model.BatchUpsertTableRowsResponse.ReadOnly
            ] = proxy(BatchUpsertTableRows, request)
            def describeTableDataImportJob(
                request: DescribeTableDataImportJobRequest
            ): IO[
              AwsError,
              zio.aws.honeycode.model.DescribeTableDataImportJobResponse.ReadOnly
            ] = proxy(DescribeTableDataImportJob, request)
            def queryTableRows(request: QueryTableRowsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.honeycode.model.TableRow.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(QueryTableRows, request)
                }
                .getOrThrowFiberFailure()
            }
            def queryTableRowsPaginated(request: QueryTableRowsRequest): IO[
              AwsError,
              zio.aws.honeycode.model.QueryTableRowsResponse.ReadOnly
            ] = proxy(QueryTableRowsPaginated, request)
            def listTables(
                request: ListTablesRequest
            ): ZStream[Any, AwsError, zio.aws.honeycode.model.Table.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListTables, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listTablesPaginated(request: ListTablesRequest): IO[
              AwsError,
              zio.aws.honeycode.model.ListTablesResponse.ReadOnly
            ] = proxy(ListTablesPaginated, request)
            def getScreenData(request: GetScreenDataRequest): IO[
              AwsError,
              zio.aws.honeycode.model.GetScreenDataResponse.ReadOnly
            ] = proxy(GetScreenData, request)
            def startTableDataImportJob(
                request: StartTableDataImportJobRequest
            ): IO[
              AwsError,
              zio.aws.honeycode.model.StartTableDataImportJobResponse.ReadOnly
            ] = proxy(StartTableDataImportJob, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.honeycode.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.honeycode.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.honeycode.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def batchUpdateTableRows(request: BatchUpdateTableRowsRequest): IO[
              AwsError,
              zio.aws.honeycode.model.BatchUpdateTableRowsResponse.ReadOnly
            ] = proxy(BatchUpdateTableRows, request)
            def batchDeleteTableRows(request: BatchDeleteTableRowsRequest): IO[
              AwsError,
              zio.aws.honeycode.model.BatchDeleteTableRowsResponse.ReadOnly
            ] = proxy(BatchDeleteTableRows, request)
            def invokeScreenAutomation(
                request: InvokeScreenAutomationRequest
            ): IO[
              AwsError,
              zio.aws.honeycode.model.InvokeScreenAutomationResponse.ReadOnly
            ] = proxy(InvokeScreenAutomation, request)
          }
        }
      }
    }
  }
}
