package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.honeycode.model.primitives.{
  ClientRequestToken,
  RowId,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class BatchDeleteTableRowsRequest(
    workbookId: ResourceId,
    tableId: ResourceId,
    rowIds: Iterable[RowId],
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsRequest = {
    import BatchDeleteTableRowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsRequest
      .builder()
      .workbookId(ResourceId.unwrap(workbookId): java.lang.String)
      .tableId(ResourceId.unwrap(tableId): java.lang.String)
      .rowIds(rowIds.map { item =>
        RowId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.BatchDeleteTableRowsRequest.ReadOnly =
    zio.aws.honeycode.model.BatchDeleteTableRowsRequest.wrap(buildAwsValue())
}
object BatchDeleteTableRowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.BatchDeleteTableRowsRequest =
      zio.aws.honeycode.model.BatchDeleteTableRowsRequest(
        workbookId,
        tableId,
        rowIds,
        clientRequestToken.map(value => value)
      )
    def workbookId: ResourceId
    def tableId: ResourceId
    def rowIds: List[RowId]
    def clientRequestToken: Optional[ClientRequestToken]
    def getWorkbookId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(workbookId)
    def getTableId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(tableId)
    def getRowIds: ZIO[Any, Nothing, List[RowId]] = ZIO.succeed(rowIds)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsRequest
  ) extends zio.aws.honeycode.model.BatchDeleteTableRowsRequest.ReadOnly {
    override val workbookId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.workbookId())
    override val tableId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.tableId())
    override val rowIds: List[RowId] = impl
      .rowIds()
      .asScala
      .map { item =>
        zio.aws.honeycode.model.primitives.RowId(item)
      }
      .toList
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.honeycode.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsRequest
  ): zio.aws.honeycode.model.BatchDeleteTableRowsRequest.ReadOnly = new Wrapper(
    impl
  )
}
