package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.honeycode.model.primitives.Fact
import scala.jdk.CollectionConverters._
final case class CellInput(
    fact: Optional[Fact] = Optional.Absent,
    facts: Optional[Iterable[Fact]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.CellInput = {
    import CellInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.CellInput
      .builder()
      .optionallyWith(fact.map(value => Fact.unwrap(value): java.lang.String))(
        _.fact
      )
      .optionallyWith(
        facts.map(value =>
          value.map { item =>
            Fact.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.facts)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.CellInput.ReadOnly =
    zio.aws.honeycode.model.CellInput.wrap(buildAwsValue())
}
object CellInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.CellInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.CellInput = zio.aws.honeycode.model
      .CellInput(fact.map(value => value), facts.map(value => value))
    def fact: Optional[Fact]
    def facts: Optional[List[Fact]]
    def getFact: ZIO[Any, AwsError, Fact] =
      AwsError.unwrapOptionField("fact", fact)
    def getFacts: ZIO[Any, AwsError, List[Fact]] =
      AwsError.unwrapOptionField("facts", facts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.CellInput
  ) extends zio.aws.honeycode.model.CellInput.ReadOnly {
    override val fact: Optional[Fact] = zio.aws.core.internal
      .optionalFromNullable(impl.fact())
      .map(value => zio.aws.honeycode.model.primitives.Fact(value))
    override val facts: Optional[List[Fact]] = zio.aws.core.internal
      .optionalFromNullable(impl.facts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.honeycode.model.primitives.Fact(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.CellInput
  ): zio.aws.honeycode.model.CellInput.ReadOnly = new Wrapper(impl)
}
