package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.honeycode.model.primitives.{
  WorkbookCursor,
  PaginationToken,
  RowId,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class ListTableRowsResponse(
    columnIds: Iterable[ResourceId],
    rows: Iterable[zio.aws.honeycode.model.TableRow],
    rowIdsNotFound: Optional[Iterable[RowId]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    workbookCursor: WorkbookCursor
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse = {
    import ListTableRowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse
      .builder()
      .columnIds(columnIds.map { item =>
        ResourceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .rows(rows.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        rowIdsNotFound.map(value =>
          value.map { item =>
            RowId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.rowIdsNotFound)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .workbookCursor(WorkbookCursor.unwrap(workbookCursor): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.ListTableRowsResponse.ReadOnly =
    zio.aws.honeycode.model.ListTableRowsResponse.wrap(buildAwsValue())
}
object ListTableRowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.ListTableRowsResponse =
      zio.aws.honeycode.model.ListTableRowsResponse(
        columnIds,
        rows.map { item =>
          item.asEditable
        },
        rowIdsNotFound.map(value => value),
        nextToken.map(value => value),
        workbookCursor
      )
    def columnIds: List[ResourceId]
    def rows: List[zio.aws.honeycode.model.TableRow.ReadOnly]
    def rowIdsNotFound: Optional[List[RowId]]
    def nextToken: Optional[PaginationToken]
    def workbookCursor: WorkbookCursor
    def getColumnIds: ZIO[Any, Nothing, List[ResourceId]] =
      ZIO.succeed(columnIds)
    def getRows
        : ZIO[Any, Nothing, List[zio.aws.honeycode.model.TableRow.ReadOnly]] =
      ZIO.succeed(rows)
    def getRowIdsNotFound: ZIO[Any, AwsError, List[RowId]] =
      AwsError.unwrapOptionField("rowIdsNotFound", rowIdsNotFound)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkbookCursor: ZIO[Any, Nothing, WorkbookCursor] =
      ZIO.succeed(workbookCursor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse
  ) extends zio.aws.honeycode.model.ListTableRowsResponse.ReadOnly {
    override val columnIds: List[ResourceId] = impl
      .columnIds()
      .asScala
      .map { item =>
        zio.aws.honeycode.model.primitives.ResourceId(item)
      }
      .toList
    override val rows: List[zio.aws.honeycode.model.TableRow.ReadOnly] = impl
      .rows()
      .asScala
      .map { item =>
        zio.aws.honeycode.model.TableRow.wrap(item)
      }
      .toList
    override val rowIdsNotFound: Optional[List[RowId]] = zio.aws.core.internal
      .optionalFromNullable(impl.rowIdsNotFound())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.honeycode.model.primitives.RowId(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.honeycode.model.primitives.PaginationToken(value))
    override val workbookCursor: WorkbookCursor =
      zio.aws.honeycode.model.primitives.WorkbookCursor(impl.workbookCursor())
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse
  ): zio.aws.honeycode.model.ListTableRowsResponse.ReadOnly = new Wrapper(impl)
}
