package zio.aws.honeycode
import zio.aws.honeycode.model.ListTableRowsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.honeycode.model.{
  BatchUpsertTableRowsRequest,
  BatchCreateTableRowsResponse,
  StartTableDataImportJobRequest,
  ListTableColumnsRequest,
  InvokeScreenAutomationRequest,
  BatchDeleteTableRowsRequest,
  QueryTableRowsResponse,
  DescribeTableDataImportJobRequest,
  Table,
  ListTagsForResourceRequest,
  InvokeScreenAutomationResponse,
  DescribeTableDataImportJobResponse,
  TableRow,
  GetScreenDataRequest,
  ListTagsForResourceResponse,
  GetScreenDataResponse,
  UntagResourceResponse,
  TableColumn,
  BatchUpdateTableRowsRequest,
  BatchUpdateTableRowsResponse,
  ListTableRowsRequest,
  UntagResourceRequest,
  BatchCreateTableRowsRequest,
  ListTableColumnsResponse,
  ListTableRowsResponse,
  ListTablesResponse,
  StartTableDataImportJobResponse,
  QueryTableRowsRequest,
  TagResourceResponse,
  BatchDeleteTableRowsResponse,
  ListTablesRequest,
  BatchUpsertTableRowsResponse,
  TagResourceRequest
}
import software.amazon.awssdk.services.honeycode.paginators.{
  ListTablesPublisher,
  QueryTableRowsPublisher,
  ListTableRowsPublisher,
  ListTableColumnsPublisher
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.honeycode.{
  HoneycodeAsyncClientBuilder,
  HoneycodeAsyncClient
}
import scala.jdk.CollectionConverters._
trait Honeycode extends AspectSupport[Honeycode] {
  val api: HoneycodeAsyncClient
  def listTableColumns(
      request: zio.aws.honeycode.model.ListTableColumnsRequest
  ): ZStream[Any, AwsError, zio.aws.honeycode.model.TableColumn.ReadOnly]
  def listTableColumnsPaginated(
      request: zio.aws.honeycode.model.ListTableColumnsRequest
  ): IO[AwsError, zio.aws.honeycode.model.ListTableColumnsResponse.ReadOnly]
  def batchCreateTableRows(
      request: zio.aws.honeycode.model.BatchCreateTableRowsRequest
  ): IO[AwsError, zio.aws.honeycode.model.BatchCreateTableRowsResponse.ReadOnly]
  def listTableRows(
      request: zio.aws.honeycode.model.ListTableRowsRequest
  ): ZStream[Any, AwsError, zio.aws.honeycode.model.TableRow.ReadOnly]
  def listTableRowsPaginated(
      request: zio.aws.honeycode.model.ListTableRowsRequest
  ): IO[AwsError, ReadOnly]
  def batchUpsertTableRows(
      request: zio.aws.honeycode.model.BatchUpsertTableRowsRequest
  ): IO[AwsError, zio.aws.honeycode.model.BatchUpsertTableRowsResponse.ReadOnly]
  def describeTableDataImportJob(
      request: zio.aws.honeycode.model.DescribeTableDataImportJobRequest
  ): IO[
    AwsError,
    zio.aws.honeycode.model.DescribeTableDataImportJobResponse.ReadOnly
  ]
  def queryTableRows(
      request: zio.aws.honeycode.model.QueryTableRowsRequest
  ): ZStream[Any, AwsError, zio.aws.honeycode.model.TableRow.ReadOnly]
  def queryTableRowsPaginated(
      request: zio.aws.honeycode.model.QueryTableRowsRequest
  ): IO[AwsError, zio.aws.honeycode.model.QueryTableRowsResponse.ReadOnly]
  def listTables(
      request: zio.aws.honeycode.model.ListTablesRequest
  ): ZStream[Any, AwsError, zio.aws.honeycode.model.Table.ReadOnly]
  def listTablesPaginated(
      request: zio.aws.honeycode.model.ListTablesRequest
  ): IO[AwsError, zio.aws.honeycode.model.ListTablesResponse.ReadOnly]
  def getScreenData(
      request: zio.aws.honeycode.model.GetScreenDataRequest
  ): IO[AwsError, zio.aws.honeycode.model.GetScreenDataResponse.ReadOnly]
  def startTableDataImportJob(
      request: zio.aws.honeycode.model.StartTableDataImportJobRequest
  ): IO[
    AwsError,
    zio.aws.honeycode.model.StartTableDataImportJobResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.honeycode.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.honeycode.model.UntagResourceResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.honeycode.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.honeycode.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: zio.aws.honeycode.model.TagResourceRequest
  ): IO[AwsError, zio.aws.honeycode.model.TagResourceResponse.ReadOnly]
  def batchUpdateTableRows(
      request: zio.aws.honeycode.model.BatchUpdateTableRowsRequest
  ): IO[AwsError, zio.aws.honeycode.model.BatchUpdateTableRowsResponse.ReadOnly]
  def batchDeleteTableRows(
      request: zio.aws.honeycode.model.BatchDeleteTableRowsRequest
  ): IO[AwsError, zio.aws.honeycode.model.BatchDeleteTableRowsResponse.ReadOnly]
  def invokeScreenAutomation(
      request: zio.aws.honeycode.model.InvokeScreenAutomationRequest
  ): IO[
    AwsError,
    zio.aws.honeycode.model.InvokeScreenAutomationResponse.ReadOnly
  ]
}
object Honeycode {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Honeycode] = customized(
    identity
  )
  def customized(
      customization: HoneycodeAsyncClientBuilder => HoneycodeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Honeycode] = managed(
    customization
  ).toLayer
  def managed(
      customization: HoneycodeAsyncClientBuilder => HoneycodeAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Honeycode] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = HoneycodeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[HoneycodeAsyncClient, HoneycodeAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[HoneycodeAsyncClient, HoneycodeAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new HoneycodeImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class HoneycodeImpl[R](
      override val api: HoneycodeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Honeycode
      with AwsServiceBase[R] {
    override val serviceName: String = "Honeycode"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): HoneycodeImpl[R1] = new HoneycodeImpl(api, newAspect, r)
    def listTableColumns(
        request: zio.aws.honeycode.model.ListTableColumnsRequest
    ): ZStream[Any, AwsError, zio.aws.honeycode.model.TableColumn.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListTableColumnsRequest,
        TableColumn,
        ListTableColumnsPublisher
      ]("listTableColumns", api.listTableColumnsPaginator, _.tableColumns())(
        request.buildAwsValue()
      ).map(item => zio.aws.honeycode.model.TableColumn.wrap(item))
        .provideEnvironment(r)
    def listTableColumnsPaginated(
        request: zio.aws.honeycode.model.ListTableColumnsRequest
    ): IO[AwsError, zio.aws.honeycode.model.ListTableColumnsResponse.ReadOnly] =
      asyncRequestResponse[ListTableColumnsRequest, ListTableColumnsResponse](
        "listTableColumns",
        api.listTableColumns
      )(request.buildAwsValue())
        .map(zio.aws.honeycode.model.ListTableColumnsResponse.wrap)
        .provideEnvironment(r)
    def batchCreateTableRows(
        request: zio.aws.honeycode.model.BatchCreateTableRowsRequest
    ): IO[
      AwsError,
      zio.aws.honeycode.model.BatchCreateTableRowsResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchCreateTableRowsRequest,
      BatchCreateTableRowsResponse
    ]("batchCreateTableRows", api.batchCreateTableRows)(request.buildAwsValue())
      .map(zio.aws.honeycode.model.BatchCreateTableRowsResponse.wrap)
      .provideEnvironment(r)
    def listTableRows(
        request: zio.aws.honeycode.model.ListTableRowsRequest
    ): ZStream[Any, AwsError, zio.aws.honeycode.model.TableRow.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListTableRowsRequest,
        TableRow,
        ListTableRowsPublisher
      ]("listTableRows", api.listTableRowsPaginator, _.rows())(
        request.buildAwsValue()
      ).map(item => zio.aws.honeycode.model.TableRow.wrap(item))
        .provideEnvironment(r)
    def listTableRowsPaginated(
        request: zio.aws.honeycode.model.ListTableRowsRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[ListTableRowsRequest, ListTableRowsResponse](
        "listTableRows",
        api.listTableRows
      )(request.buildAwsValue())
        .map(zio.aws.honeycode.model.ListTableRowsResponse.wrap)
        .provideEnvironment(r)
    def batchUpsertTableRows(
        request: zio.aws.honeycode.model.BatchUpsertTableRowsRequest
    ): IO[
      AwsError,
      zio.aws.honeycode.model.BatchUpsertTableRowsResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchUpsertTableRowsRequest,
      BatchUpsertTableRowsResponse
    ]("batchUpsertTableRows", api.batchUpsertTableRows)(request.buildAwsValue())
      .map(zio.aws.honeycode.model.BatchUpsertTableRowsResponse.wrap)
      .provideEnvironment(r)
    def describeTableDataImportJob(
        request: zio.aws.honeycode.model.DescribeTableDataImportJobRequest
    ): IO[
      AwsError,
      zio.aws.honeycode.model.DescribeTableDataImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTableDataImportJobRequest,
      DescribeTableDataImportJobResponse
    ]("describeTableDataImportJob", api.describeTableDataImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.honeycode.model.DescribeTableDataImportJobResponse.wrap)
      .provideEnvironment(r)
    def queryTableRows(
        request: zio.aws.honeycode.model.QueryTableRowsRequest
    ): ZStream[Any, AwsError, zio.aws.honeycode.model.TableRow.ReadOnly] =
      asyncJavaPaginatedRequest[
        QueryTableRowsRequest,
        TableRow,
        QueryTableRowsPublisher
      ]("queryTableRows", api.queryTableRowsPaginator, _.rows())(
        request.buildAwsValue()
      ).map(item => zio.aws.honeycode.model.TableRow.wrap(item))
        .provideEnvironment(r)
    def queryTableRowsPaginated(
        request: zio.aws.honeycode.model.QueryTableRowsRequest
    ): IO[AwsError, zio.aws.honeycode.model.QueryTableRowsResponse.ReadOnly] =
      asyncRequestResponse[QueryTableRowsRequest, QueryTableRowsResponse](
        "queryTableRows",
        api.queryTableRows
      )(request.buildAwsValue())
        .map(zio.aws.honeycode.model.QueryTableRowsResponse.wrap)
        .provideEnvironment(r)
    def listTables(
        request: zio.aws.honeycode.model.ListTablesRequest
    ): ZStream[Any, AwsError, zio.aws.honeycode.model.Table.ReadOnly] =
      asyncJavaPaginatedRequest[ListTablesRequest, Table, ListTablesPublisher](
        "listTables",
        api.listTablesPaginator,
        _.tables()
      )(request.buildAwsValue())
        .map(item => zio.aws.honeycode.model.Table.wrap(item))
        .provideEnvironment(r)
    def listTablesPaginated(
        request: zio.aws.honeycode.model.ListTablesRequest
    ): IO[AwsError, zio.aws.honeycode.model.ListTablesResponse.ReadOnly] =
      asyncRequestResponse[ListTablesRequest, ListTablesResponse](
        "listTables",
        api.listTables
      )(request.buildAwsValue())
        .map(zio.aws.honeycode.model.ListTablesResponse.wrap)
        .provideEnvironment(r)
    def getScreenData(
        request: zio.aws.honeycode.model.GetScreenDataRequest
    ): IO[AwsError, zio.aws.honeycode.model.GetScreenDataResponse.ReadOnly] =
      asyncRequestResponse[GetScreenDataRequest, GetScreenDataResponse](
        "getScreenData",
        api.getScreenData
      )(request.buildAwsValue())
        .map(zio.aws.honeycode.model.GetScreenDataResponse.wrap)
        .provideEnvironment(r)
    def startTableDataImportJob(
        request: zio.aws.honeycode.model.StartTableDataImportJobRequest
    ): IO[
      AwsError,
      zio.aws.honeycode.model.StartTableDataImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      StartTableDataImportJobRequest,
      StartTableDataImportJobResponse
    ]("startTableDataImportJob", api.startTableDataImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.honeycode.model.StartTableDataImportJobResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.honeycode.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.honeycode.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.honeycode.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.honeycode.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.honeycode.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.honeycode.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.honeycode.model.TagResourceRequest
    ): IO[AwsError, zio.aws.honeycode.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.honeycode.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def batchUpdateTableRows(
        request: zio.aws.honeycode.model.BatchUpdateTableRowsRequest
    ): IO[
      AwsError,
      zio.aws.honeycode.model.BatchUpdateTableRowsResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchUpdateTableRowsRequest,
      BatchUpdateTableRowsResponse
    ]("batchUpdateTableRows", api.batchUpdateTableRows)(request.buildAwsValue())
      .map(zio.aws.honeycode.model.BatchUpdateTableRowsResponse.wrap)
      .provideEnvironment(r)
    def batchDeleteTableRows(
        request: zio.aws.honeycode.model.BatchDeleteTableRowsRequest
    ): IO[
      AwsError,
      zio.aws.honeycode.model.BatchDeleteTableRowsResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchDeleteTableRowsRequest,
      BatchDeleteTableRowsResponse
    ]("batchDeleteTableRows", api.batchDeleteTableRows)(request.buildAwsValue())
      .map(zio.aws.honeycode.model.BatchDeleteTableRowsResponse.wrap)
      .provideEnvironment(r)
    def invokeScreenAutomation(
        request: zio.aws.honeycode.model.InvokeScreenAutomationRequest
    ): IO[
      AwsError,
      zio.aws.honeycode.model.InvokeScreenAutomationResponse.ReadOnly
    ] = asyncRequestResponse[
      InvokeScreenAutomationRequest,
      InvokeScreenAutomationResponse
    ]("invokeScreenAutomation", api.invokeScreenAutomation)(
      request.buildAwsValue()
    ).map(zio.aws.honeycode.model.InvokeScreenAutomationResponse.wrap)
      .provideEnvironment(r)
  }
  def listTableColumns(
      request: zio.aws.honeycode.model.ListTableColumnsRequest
  ): ZStream[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.TableColumn.ReadOnly
  ] = ZStream.serviceWithStream(_.listTableColumns(request))
  def listTableColumnsPaginated(
      request: zio.aws.honeycode.model.ListTableColumnsRequest
  ): ZIO[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.ListTableColumnsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTableColumnsPaginated(request))
  def batchCreateTableRows(
      request: zio.aws.honeycode.model.BatchCreateTableRowsRequest
  ): ZIO[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.BatchCreateTableRowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchCreateTableRows(request))
  def listTableRows(
      request: zio.aws.honeycode.model.ListTableRowsRequest
  ): ZStream[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.TableRow.ReadOnly
  ] = ZStream.serviceWithStream(_.listTableRows(request))
  def listTableRowsPaginated(
      request: zio.aws.honeycode.model.ListTableRowsRequest
  ): ZIO[zio.aws.honeycode.Honeycode, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listTableRowsPaginated(request))
  def batchUpsertTableRows(
      request: zio.aws.honeycode.model.BatchUpsertTableRowsRequest
  ): ZIO[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.BatchUpsertTableRowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchUpsertTableRows(request))
  def describeTableDataImportJob(
      request: zio.aws.honeycode.model.DescribeTableDataImportJobRequest
  ): ZIO[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.DescribeTableDataImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTableDataImportJob(request))
  def queryTableRows(
      request: zio.aws.honeycode.model.QueryTableRowsRequest
  ): ZStream[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.TableRow.ReadOnly
  ] = ZStream.serviceWithStream(_.queryTableRows(request))
  def queryTableRowsPaginated(
      request: zio.aws.honeycode.model.QueryTableRowsRequest
  ): ZIO[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.QueryTableRowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.queryTableRowsPaginated(request))
  def listTables(request: zio.aws.honeycode.model.ListTablesRequest): ZStream[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.Table.ReadOnly
  ] = ZStream.serviceWithStream(_.listTables(request))
  def listTablesPaginated(
      request: zio.aws.honeycode.model.ListTablesRequest
  ): ZIO[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.ListTablesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTablesPaginated(request))
  def getScreenData(request: zio.aws.honeycode.model.GetScreenDataRequest): ZIO[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.GetScreenDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getScreenData(request))
  def startTableDataImportJob(
      request: zio.aws.honeycode.model.StartTableDataImportJobRequest
  ): ZIO[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.StartTableDataImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startTableDataImportJob(request))
  def untagResource(request: zio.aws.honeycode.model.UntagResourceRequest): ZIO[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(
      request: zio.aws.honeycode.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: zio.aws.honeycode.model.TagResourceRequest): ZIO[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def batchUpdateTableRows(
      request: zio.aws.honeycode.model.BatchUpdateTableRowsRequest
  ): ZIO[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.BatchUpdateTableRowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchUpdateTableRows(request))
  def batchDeleteTableRows(
      request: zio.aws.honeycode.model.BatchDeleteTableRowsRequest
  ): ZIO[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.BatchDeleteTableRowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDeleteTableRows(request))
  def invokeScreenAutomation(
      request: zio.aws.honeycode.model.InvokeScreenAutomationRequest
  ): ZIO[
    zio.aws.honeycode.Honeycode,
    AwsError,
    zio.aws.honeycode.model.InvokeScreenAutomationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.invokeScreenAutomation(request))
}
