package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.honeycode.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.honeycode.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.ListTagsForResourceResponse =
      zio.aws.honeycode.model
        .ListTagsForResourceResponse(tags.map(value => value))
    def tags: Optional[Map[TagKey, TagValue]]
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.ListTagsForResourceResponse
  ) extends zio.aws.honeycode.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.honeycode.model.primitives
              .TagKey(key) -> zio.aws.honeycode.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.ListTagsForResourceResponse
  ): zio.aws.honeycode.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
