package zio.aws.iam.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  ServiceNameType,
  DateType,
  OrganizationsEntityPathType,
  ServiceNamespaceType,
  IntegerType,
  StringType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AccessDetail(
    serviceName: ServiceNameType,
    serviceNamespace: ServiceNamespaceType,
    region: Option[StringType] = None,
    entityPath: Option[OrganizationsEntityPathType] = None,
    lastAuthenticatedTime: Option[DateType] = None,
    totalAuthenticatedEntities: Option[IntegerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.AccessDetail = {
    import AccessDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.AccessDetail
      .builder()
      .serviceName(ServiceNameType.unwrap(serviceName): java.lang.String)
      .serviceNamespace(
        ServiceNamespaceType.unwrap(serviceNamespace): java.lang.String
      )
      .optionallyWith(
        region.map(value => StringType.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        entityPath.map(value =>
          OrganizationsEntityPathType.unwrap(value): java.lang.String
        )
      )(_.entityPath)
      .optionallyWith(
        lastAuthenticatedTime.map(value => DateType.unwrap(value): Instant)
      )(_.lastAuthenticatedTime)
      .optionallyWith(
        totalAuthenticatedEntities.map(value =>
          IntegerType.unwrap(value): Integer
        )
      )(_.totalAuthenticatedEntities)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.AccessDetail.ReadOnly =
    zio.aws.iam.model.AccessDetail.wrap(buildAwsValue())
}
object AccessDetail {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.AccessDetail] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.AccessDetail =
      zio.aws.iam.model.AccessDetail(
        serviceName,
        serviceNamespace,
        region.map(value => value),
        entityPath.map(value => value),
        lastAuthenticatedTime.map(value => value),
        totalAuthenticatedEntities.map(value => value)
      )
    def serviceName: ServiceNameType
    def serviceNamespace: ServiceNamespaceType
    def region: Option[StringType]
    def entityPath: Option[OrganizationsEntityPathType]
    def lastAuthenticatedTime: Option[DateType]
    def totalAuthenticatedEntities: Option[IntegerType]
    def getServiceName: ZIO[Any, Nothing, ServiceNameType] =
      ZIO.succeed(serviceName)
    def getServiceNamespace: ZIO[Any, Nothing, ServiceNamespaceType] =
      ZIO.succeed(serviceNamespace)
    def getRegion: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("region", region)
    def getEntityPath: ZIO[Any, AwsError, OrganizationsEntityPathType] =
      AwsError.unwrapOptionField("entityPath", entityPath)
    def getLastAuthenticatedTime: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastAuthenticatedTime", lastAuthenticatedTime)
    def getTotalAuthenticatedEntities: ZIO[Any, AwsError, IntegerType] =
      AwsError.unwrapOptionField(
        "totalAuthenticatedEntities",
        totalAuthenticatedEntities
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.AccessDetail
  ) extends zio.aws.iam.model.AccessDetail.ReadOnly {
    override val serviceName: ServiceNameType =
      zio.aws.iam.model.primitives.ServiceNameType(impl.serviceName())
    override val serviceNamespace: ServiceNamespaceType =
      zio.aws.iam.model.primitives.ServiceNamespaceType(impl.serviceNamespace())
    override val region: Option[StringType] = scala
      .Option(impl.region())
      .map(value => zio.aws.iam.model.primitives.StringType(value))
    override val entityPath: Option[OrganizationsEntityPathType] = scala
      .Option(impl.entityPath())
      .map(value =>
        zio.aws.iam.model.primitives.OrganizationsEntityPathType(value)
      )
    override val lastAuthenticatedTime: Option[DateType] = scala
      .Option(impl.lastAuthenticatedTime())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val totalAuthenticatedEntities: Option[IntegerType] = scala
      .Option(impl.totalAuthenticatedEntities())
      .map(value => zio.aws.iam.model.primitives.IntegerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.AccessDetail
  ): zio.aws.iam.model.AccessDetail.ReadOnly = new Wrapper(impl)
}
