package zio.aws.iam.model
import zio.aws.iam.model.primitives.{StringType, DateType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AccessKeyLastUsed(
    lastUsedDate: DateType,
    serviceName: StringType,
    region: StringType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.AccessKeyLastUsed = {
    import AccessKeyLastUsed.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.AccessKeyLastUsed
      .builder()
      .lastUsedDate(DateType.unwrap(lastUsedDate): Instant)
      .serviceName(StringType.unwrap(serviceName): java.lang.String)
      .region(StringType.unwrap(region): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.AccessKeyLastUsed.ReadOnly =
    zio.aws.iam.model.AccessKeyLastUsed.wrap(buildAwsValue())
}
object AccessKeyLastUsed {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.AccessKeyLastUsed
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.AccessKeyLastUsed =
      zio.aws.iam.model.AccessKeyLastUsed(lastUsedDate, serviceName, region)
    def lastUsedDate: DateType
    def serviceName: StringType
    def region: StringType
    def getLastUsedDate: ZIO[Any, Nothing, DateType] = ZIO.succeed(lastUsedDate)
    def getServiceName: ZIO[Any, Nothing, StringType] = ZIO.succeed(serviceName)
    def getRegion: ZIO[Any, Nothing, StringType] = ZIO.succeed(region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.AccessKeyLastUsed
  ) extends zio.aws.iam.model.AccessKeyLastUsed.ReadOnly {
    override val lastUsedDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.lastUsedDate())
    override val serviceName: StringType =
      zio.aws.iam.model.primitives.StringType(impl.serviceName())
    override val region: StringType =
      zio.aws.iam.model.primitives.StringType(impl.region())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.AccessKeyLastUsed
  ): zio.aws.iam.model.AccessKeyLastUsed.ReadOnly = new Wrapper(impl)
}
